/* THIS FILE IS AUTOGENERATED FROM Sanitizer.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_SANITIZERBINDING_H_
#define DOM_SANITIZERBINDING_H_

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

class Document;
class DocumentFragment;
struct NativePropertyHooks;
class OwningDocumentFragmentOrDocument;
class OwningStringOrSanitizerAttributeNamespace;
class OwningStringOrSanitizerElementNamespace;
class OwningStringOrSanitizerElementNamespaceWithAttributes;
class ProtoAndIfaceCache;
class Sanitizer;
struct SanitizerAttributeNamespaceAtoms;
struct SanitizerConfigAtoms;
struct SanitizerElementNamespaceAtoms;
struct SanitizerElementNamespaceWithAttributesAtoms;
class StringOrSanitizerAttributeNamespace;
class StringOrSanitizerElementNamespace;
class StringOrSanitizerElementNamespaceWithAttributes;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningDocumentFragmentOrDocument& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningDocumentFragmentOrDocument& aUnion);


class DocumentFragmentOrDocument : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eDocumentFragment,
    eDocument
  };
public:
  enum class Type
  {
    eDocumentFragment = TypeOrUninit::eDocumentFragment,
    eDocument = TypeOrUninit::eDocument
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::DocumentFragment> > mDocumentFragment;
    UnionMember<NonNull<mozilla::dom::Document> > mDocument;

  };

  TypeOrUninit mType;
  Value mValue;

  DocumentFragmentOrDocument(const DocumentFragmentOrDocument&) = delete;
  DocumentFragmentOrDocument& operator=(const DocumentFragmentOrDocument&) = delete;
public:
  explicit inline DocumentFragmentOrDocument()
    : mType(eUninitialized)
  {
  }

  inline ~DocumentFragmentOrDocument()
  {
    Uninit();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::DocumentFragment>&
  RawSetAsDocumentFragment()
  {
    if (mType == eDocumentFragment) {
      return mValue.mDocumentFragment.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDocumentFragment;
    return mValue.mDocumentFragment.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::DocumentFragment>&
  SetAsDocumentFragment()
  {
    if (mType == eDocumentFragment) {
      return mValue.mDocumentFragment.Value();
    }
    Uninit();
    mType = eDocumentFragment;
    return mValue.mDocumentFragment.SetValue();
  }

  inline bool
  IsDocumentFragment() const
  {
    return mType == eDocumentFragment;
  }

  inline NonNull<mozilla::dom::DocumentFragment>&
  GetAsDocumentFragment()
  {
    MOZ_RELEASE_ASSERT(IsDocumentFragment(), "Wrong type!");
    return mValue.mDocumentFragment.Value();
  }

  inline mozilla::dom::DocumentFragment&
  GetAsDocumentFragment() const
  {
    MOZ_RELEASE_ASSERT(IsDocumentFragment(), "Wrong type!");
    return mValue.mDocumentFragment.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Document>&
  RawSetAsDocument()
  {
    if (mType == eDocument) {
      return mValue.mDocument.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDocument;
    return mValue.mDocument.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Document>&
  SetAsDocument()
  {
    if (mType == eDocument) {
      return mValue.mDocument.Value();
    }
    Uninit();
    mType = eDocument;
    return mValue.mDocument.SetValue();
  }

  inline bool
  IsDocument() const
  {
    return mType == eDocument;
  }

  inline NonNull<mozilla::dom::Document>&
  GetAsDocument()
  {
    MOZ_RELEASE_ASSERT(IsDocument(), "Wrong type!");
    return mValue.mDocument.Value();
  }

  inline mozilla::dom::Document&
  GetAsDocument() const
  {
    MOZ_RELEASE_ASSERT(IsDocument(), "Wrong type!");
    return mValue.mDocument.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eDocumentFragment: {
        DestroyDocumentFragment();
        break;
      }
      case eDocument: {
        DestroyDocument();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToDocumentFragment(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDocumentFragment(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyDocumentFragment()
  {
    MOZ_RELEASE_ASSERT(IsDocumentFragment(), "Wrong type!");
    mValue.mDocumentFragment.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToDocument(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDocument(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyDocument()
  {
    MOZ_RELEASE_ASSERT(IsDocument(), "Wrong type!");
    mValue.mDocument.Destroy();
    mType = eUninitialized;
  }
};


class OwningDocumentFragmentOrDocument : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningDocumentFragmentOrDocument& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eDocumentFragment,
    eDocument
  };
public:
  enum class Type
  {
    eDocumentFragment = TypeOrUninit::eDocumentFragment,
    eDocument = TypeOrUninit::eDocument
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::DocumentFragment> > mDocumentFragment;
    UnionMember<OwningNonNull<mozilla::dom::Document> > mDocument;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningDocumentFragmentOrDocument()
    : mType(eUninitialized)
  {
  }

  OwningDocumentFragmentOrDocument(OwningDocumentFragmentOrDocument&& aOther);

  explicit inline OwningDocumentFragmentOrDocument(const OwningDocumentFragmentOrDocument& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningDocumentFragmentOrDocument()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::DocumentFragment>&
  RawSetAsDocumentFragment();

  [[nodiscard]] OwningNonNull<mozilla::dom::DocumentFragment>&
  SetAsDocumentFragment();

  inline bool
  IsDocumentFragment() const
  {
    return mType == eDocumentFragment;
  }

  inline OwningNonNull<mozilla::dom::DocumentFragment>&
  GetAsDocumentFragment()
  {
    MOZ_RELEASE_ASSERT(IsDocumentFragment(), "Wrong type!");
    return mValue.mDocumentFragment.Value();
  }

  inline OwningNonNull<mozilla::dom::DocumentFragment> const &
  GetAsDocumentFragment() const
  {
    MOZ_RELEASE_ASSERT(IsDocumentFragment(), "Wrong type!");
    return mValue.mDocumentFragment.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::Document>&
  RawSetAsDocument();

  [[nodiscard]] OwningNonNull<mozilla::dom::Document>&
  SetAsDocument();

  inline bool
  IsDocument() const
  {
    return mType == eDocument;
  }

  inline OwningNonNull<mozilla::dom::Document>&
  GetAsDocument()
  {
    MOZ_RELEASE_ASSERT(IsDocument(), "Wrong type!");
    return mValue.mDocument.Value();
  }

  inline OwningNonNull<mozilla::dom::Document> const &
  GetAsDocument() const
  {
    MOZ_RELEASE_ASSERT(IsDocument(), "Wrong type!");
    return mValue.mDocument.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningDocumentFragmentOrDocument&
  operator=(OwningDocumentFragmentOrDocument&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningDocumentFragmentOrDocument&
  operator=(const OwningDocumentFragmentOrDocument& aOther);

private:
  bool
  TrySetToDocumentFragment(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDocumentFragment(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyDocumentFragment();

  bool
  TrySetToDocument(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDocument(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyDocument();
};


struct SanitizerAttributeNamespace : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mName;
  MOZ_INIT_OUTSIDE_CTOR nsString mNamespace;

  SanitizerAttributeNamespace();

  explicit inline SanitizerAttributeNamespace(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  SanitizerAttributeNamespace(SanitizerAttributeNamespace&& aOther) = default;

  explicit inline SanitizerAttributeNamespace(const SanitizerAttributeNamespace& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  SanitizerAttributeNamespace&
  operator=(const SanitizerAttributeNamespace& aOther);

private:
  static bool
  InitIds(JSContext* cx, SanitizerAttributeNamespaceAtoms* atomsCache);
};

namespace binding_detail {
struct FastSanitizerAttributeNamespace : public SanitizerAttributeNamespace
{
  inline FastSanitizerAttributeNamespace()
    : SanitizerAttributeNamespace(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct SanitizerElementNamespace : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mName;
  MOZ_INIT_OUTSIDE_CTOR nsString mNamespace;

  SanitizerElementNamespace();

  explicit inline SanitizerElementNamespace(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  SanitizerElementNamespace(SanitizerElementNamespace&& aOther) = default;

  explicit inline SanitizerElementNamespace(const SanitizerElementNamespace& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  SanitizerElementNamespace&
  operator=(const SanitizerElementNamespace& aOther);

private:
  static bool
  InitIds(JSContext* cx, SanitizerElementNamespaceAtoms* atomsCache);
};

namespace binding_detail {
struct FastSanitizerElementNamespace : public SanitizerElementNamespace
{
  inline FastSanitizerElementNamespace()
    : SanitizerElementNamespace(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class StringOrSanitizerAttributeNamespace : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eSanitizerAttributeNamespace
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eSanitizerAttributeNamespace = TypeOrUninit::eSanitizerAttributeNamespace
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char16_t> > mString;
    UnionMember<binding_detail::FastSanitizerAttributeNamespace > mSanitizerAttributeNamespace;

  };

  TypeOrUninit mType;
  Value mValue;

  StringOrSanitizerAttributeNamespace(const StringOrSanitizerAttributeNamespace&) = delete;
  StringOrSanitizerAttributeNamespace& operator=(const StringOrSanitizerAttributeNamespace&) = delete;
public:
  explicit inline StringOrSanitizerAttributeNamespace()
    : mType(eUninitialized)
  {
  }

  inline ~StringOrSanitizerAttributeNamespace()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  [[nodiscard]] inline binding_detail::FastSanitizerAttributeNamespace&
  RawSetAsSanitizerAttributeNamespace()
  {
    if (mType == eSanitizerAttributeNamespace) {
      return mValue.mSanitizerAttributeNamespace.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eSanitizerAttributeNamespace;
    return mValue.mSanitizerAttributeNamespace.SetValue();
  }

  [[nodiscard]] inline binding_detail::FastSanitizerAttributeNamespace&
  SetAsSanitizerAttributeNamespace()
  {
    if (mType == eSanitizerAttributeNamespace) {
      return mValue.mSanitizerAttributeNamespace.Value();
    }
    Uninit();
    mType = eSanitizerAttributeNamespace;
    return mValue.mSanitizerAttributeNamespace.SetValue();
  }

  inline bool
  IsSanitizerAttributeNamespace() const
  {
    return mType == eSanitizerAttributeNamespace;
  }

  inline binding_detail::FastSanitizerAttributeNamespace&
  GetAsSanitizerAttributeNamespace()
  {
    MOZ_RELEASE_ASSERT(IsSanitizerAttributeNamespace(), "Wrong type!");
    return mValue.mSanitizerAttributeNamespace.Value();
  }

  inline const SanitizerAttributeNamespace&
  GetAsSanitizerAttributeNamespace() const
  {
    MOZ_RELEASE_ASSERT(IsSanitizerAttributeNamespace(), "Wrong type!");
    return mValue.mSanitizerAttributeNamespace.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
      case eSanitizerAttributeNamespace: {
        DestroySanitizerAttributeNamespace();
        break;
      }
    }
  }

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToSanitizerAttributeNamespace(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSanitizerAttributeNamespace(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroySanitizerAttributeNamespace()
  {
    MOZ_RELEASE_ASSERT(IsSanitizerAttributeNamespace(), "Wrong type!");
    mValue.mSanitizerAttributeNamespace.Destroy();
    mType = eUninitialized;
  }
};


class OwningStringOrSanitizerAttributeNamespace : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eSanitizerAttributeNamespace
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eSanitizerAttributeNamespace = TypeOrUninit::eSanitizerAttributeNamespace
  };

private:
  union Value
  {
    UnionMember<nsString > mString;
    UnionMember<SanitizerAttributeNamespace > mSanitizerAttributeNamespace;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningStringOrSanitizerAttributeNamespace()
    : mType(eUninitialized)
  {
  }

  OwningStringOrSanitizerAttributeNamespace(OwningStringOrSanitizerAttributeNamespace&& aOther);

  explicit inline OwningStringOrSanitizerAttributeNamespace(const OwningStringOrSanitizerAttributeNamespace& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningStringOrSanitizerAttributeNamespace()
  {
    Uninit();
  }

  [[nodiscard]] nsString&
  RawSetAsString();

  [[nodiscard]] nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  [[nodiscard]] SanitizerAttributeNamespace&
  RawSetAsSanitizerAttributeNamespace();

  [[nodiscard]] SanitizerAttributeNamespace&
  SetAsSanitizerAttributeNamespace();

  inline bool
  IsSanitizerAttributeNamespace() const
  {
    return mType == eSanitizerAttributeNamespace;
  }

  inline SanitizerAttributeNamespace&
  GetAsSanitizerAttributeNamespace()
  {
    MOZ_RELEASE_ASSERT(IsSanitizerAttributeNamespace(), "Wrong type!");
    return mValue.mSanitizerAttributeNamespace.Value();
  }

  inline SanitizerAttributeNamespace const &
  GetAsSanitizerAttributeNamespace() const
  {
    MOZ_RELEASE_ASSERT(IsSanitizerAttributeNamespace(), "Wrong type!");
    return mValue.mSanitizerAttributeNamespace.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  OwningStringOrSanitizerAttributeNamespace&
  operator=(OwningStringOrSanitizerAttributeNamespace&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningStringOrSanitizerAttributeNamespace&
  operator=(const OwningStringOrSanitizerAttributeNamespace& aOther);

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();

  bool
  TrySetToSanitizerAttributeNamespace(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSanitizerAttributeNamespace(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroySanitizerAttributeNamespace();
};


class StringOrSanitizerElementNamespace : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eSanitizerElementNamespace
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eSanitizerElementNamespace = TypeOrUninit::eSanitizerElementNamespace
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char16_t> > mString;
    UnionMember<binding_detail::FastSanitizerElementNamespace > mSanitizerElementNamespace;

  };

  TypeOrUninit mType;
  Value mValue;

  StringOrSanitizerElementNamespace(const StringOrSanitizerElementNamespace&) = delete;
  StringOrSanitizerElementNamespace& operator=(const StringOrSanitizerElementNamespace&) = delete;
public:
  explicit inline StringOrSanitizerElementNamespace()
    : mType(eUninitialized)
  {
  }

  inline ~StringOrSanitizerElementNamespace()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  [[nodiscard]] inline binding_detail::FastSanitizerElementNamespace&
  RawSetAsSanitizerElementNamespace()
  {
    if (mType == eSanitizerElementNamespace) {
      return mValue.mSanitizerElementNamespace.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eSanitizerElementNamespace;
    return mValue.mSanitizerElementNamespace.SetValue();
  }

  [[nodiscard]] inline binding_detail::FastSanitizerElementNamespace&
  SetAsSanitizerElementNamespace()
  {
    if (mType == eSanitizerElementNamespace) {
      return mValue.mSanitizerElementNamespace.Value();
    }
    Uninit();
    mType = eSanitizerElementNamespace;
    return mValue.mSanitizerElementNamespace.SetValue();
  }

  inline bool
  IsSanitizerElementNamespace() const
  {
    return mType == eSanitizerElementNamespace;
  }

  inline binding_detail::FastSanitizerElementNamespace&
  GetAsSanitizerElementNamespace()
  {
    MOZ_RELEASE_ASSERT(IsSanitizerElementNamespace(), "Wrong type!");
    return mValue.mSanitizerElementNamespace.Value();
  }

  inline const SanitizerElementNamespace&
  GetAsSanitizerElementNamespace() const
  {
    MOZ_RELEASE_ASSERT(IsSanitizerElementNamespace(), "Wrong type!");
    return mValue.mSanitizerElementNamespace.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
      case eSanitizerElementNamespace: {
        DestroySanitizerElementNamespace();
        break;
      }
    }
  }

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToSanitizerElementNamespace(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSanitizerElementNamespace(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroySanitizerElementNamespace()
  {
    MOZ_RELEASE_ASSERT(IsSanitizerElementNamespace(), "Wrong type!");
    mValue.mSanitizerElementNamespace.Destroy();
    mType = eUninitialized;
  }
};


class OwningStringOrSanitizerElementNamespace : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eSanitizerElementNamespace
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eSanitizerElementNamespace = TypeOrUninit::eSanitizerElementNamespace
  };

private:
  union Value
  {
    UnionMember<nsString > mString;
    UnionMember<SanitizerElementNamespace > mSanitizerElementNamespace;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningStringOrSanitizerElementNamespace()
    : mType(eUninitialized)
  {
  }

  OwningStringOrSanitizerElementNamespace(OwningStringOrSanitizerElementNamespace&& aOther);

  explicit inline OwningStringOrSanitizerElementNamespace(const OwningStringOrSanitizerElementNamespace& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningStringOrSanitizerElementNamespace()
  {
    Uninit();
  }

  [[nodiscard]] nsString&
  RawSetAsString();

  [[nodiscard]] nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  [[nodiscard]] SanitizerElementNamespace&
  RawSetAsSanitizerElementNamespace();

  [[nodiscard]] SanitizerElementNamespace&
  SetAsSanitizerElementNamespace();

  inline bool
  IsSanitizerElementNamespace() const
  {
    return mType == eSanitizerElementNamespace;
  }

  inline SanitizerElementNamespace&
  GetAsSanitizerElementNamespace()
  {
    MOZ_RELEASE_ASSERT(IsSanitizerElementNamespace(), "Wrong type!");
    return mValue.mSanitizerElementNamespace.Value();
  }

  inline SanitizerElementNamespace const &
  GetAsSanitizerElementNamespace() const
  {
    MOZ_RELEASE_ASSERT(IsSanitizerElementNamespace(), "Wrong type!");
    return mValue.mSanitizerElementNamespace.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  OwningStringOrSanitizerElementNamespace&
  operator=(OwningStringOrSanitizerElementNamespace&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningStringOrSanitizerElementNamespace&
  operator=(const OwningStringOrSanitizerElementNamespace& aOther);

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();

  bool
  TrySetToSanitizerElementNamespace(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSanitizerElementNamespace(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroySanitizerElementNamespace();
};


struct SanitizerElementNamespaceWithAttributes : public SanitizerElementNamespace
{
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<OwningStringOrSanitizerAttributeNamespace>> mAttributes;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<OwningStringOrSanitizerAttributeNamespace>> mRemoveAttributes;

  SanitizerElementNamespaceWithAttributes();

  explicit inline SanitizerElementNamespaceWithAttributes(const FastDictionaryInitializer& )
    : SanitizerElementNamespace(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  SanitizerElementNamespaceWithAttributes(SanitizerElementNamespaceWithAttributes&& aOther) = default;

  explicit inline SanitizerElementNamespaceWithAttributes(const SanitizerElementNamespaceWithAttributes& aOther)
    : SanitizerElementNamespace(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  SanitizerElementNamespaceWithAttributes&
  operator=(const SanitizerElementNamespaceWithAttributes& aOther);

private:
  static bool
  InitIds(JSContext* cx, SanitizerElementNamespaceWithAttributesAtoms* atomsCache);
};

namespace binding_detail {
struct FastSanitizerElementNamespaceWithAttributes : public SanitizerElementNamespaceWithAttributes
{
  inline FastSanitizerElementNamespaceWithAttributes()
    : SanitizerElementNamespaceWithAttributes(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class StringOrSanitizerElementNamespaceWithAttributes : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eSanitizerElementNamespaceWithAttributes
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eSanitizerElementNamespaceWithAttributes = TypeOrUninit::eSanitizerElementNamespaceWithAttributes
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char16_t> > mString;
    UnionMember<binding_detail::FastSanitizerElementNamespaceWithAttributes > mSanitizerElementNamespaceWithAttributes;

  };

  TypeOrUninit mType;
  Value mValue;

  StringOrSanitizerElementNamespaceWithAttributes(const StringOrSanitizerElementNamespaceWithAttributes&) = delete;
  StringOrSanitizerElementNamespaceWithAttributes& operator=(const StringOrSanitizerElementNamespaceWithAttributes&) = delete;
public:
  explicit inline StringOrSanitizerElementNamespaceWithAttributes()
    : mType(eUninitialized)
  {
  }

  inline ~StringOrSanitizerElementNamespaceWithAttributes()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  [[nodiscard]] inline binding_detail::FastSanitizerElementNamespaceWithAttributes&
  RawSetAsSanitizerElementNamespaceWithAttributes()
  {
    if (mType == eSanitizerElementNamespaceWithAttributes) {
      return mValue.mSanitizerElementNamespaceWithAttributes.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eSanitizerElementNamespaceWithAttributes;
    return mValue.mSanitizerElementNamespaceWithAttributes.SetValue();
  }

  [[nodiscard]] inline binding_detail::FastSanitizerElementNamespaceWithAttributes&
  SetAsSanitizerElementNamespaceWithAttributes()
  {
    if (mType == eSanitizerElementNamespaceWithAttributes) {
      return mValue.mSanitizerElementNamespaceWithAttributes.Value();
    }
    Uninit();
    mType = eSanitizerElementNamespaceWithAttributes;
    return mValue.mSanitizerElementNamespaceWithAttributes.SetValue();
  }

  inline bool
  IsSanitizerElementNamespaceWithAttributes() const
  {
    return mType == eSanitizerElementNamespaceWithAttributes;
  }

  inline binding_detail::FastSanitizerElementNamespaceWithAttributes&
  GetAsSanitizerElementNamespaceWithAttributes()
  {
    MOZ_RELEASE_ASSERT(IsSanitizerElementNamespaceWithAttributes(), "Wrong type!");
    return mValue.mSanitizerElementNamespaceWithAttributes.Value();
  }

  inline const SanitizerElementNamespaceWithAttributes&
  GetAsSanitizerElementNamespaceWithAttributes() const
  {
    MOZ_RELEASE_ASSERT(IsSanitizerElementNamespaceWithAttributes(), "Wrong type!");
    return mValue.mSanitizerElementNamespaceWithAttributes.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
      case eSanitizerElementNamespaceWithAttributes: {
        DestroySanitizerElementNamespaceWithAttributes();
        break;
      }
    }
  }

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToSanitizerElementNamespaceWithAttributes(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSanitizerElementNamespaceWithAttributes(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroySanitizerElementNamespaceWithAttributes()
  {
    MOZ_RELEASE_ASSERT(IsSanitizerElementNamespaceWithAttributes(), "Wrong type!");
    mValue.mSanitizerElementNamespaceWithAttributes.Destroy();
    mType = eUninitialized;
  }
};


class OwningStringOrSanitizerElementNamespaceWithAttributes : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eSanitizerElementNamespaceWithAttributes
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eSanitizerElementNamespaceWithAttributes = TypeOrUninit::eSanitizerElementNamespaceWithAttributes
  };

private:
  union Value
  {
    UnionMember<nsString > mString;
    UnionMember<SanitizerElementNamespaceWithAttributes > mSanitizerElementNamespaceWithAttributes;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningStringOrSanitizerElementNamespaceWithAttributes()
    : mType(eUninitialized)
  {
  }

  OwningStringOrSanitizerElementNamespaceWithAttributes(OwningStringOrSanitizerElementNamespaceWithAttributes&& aOther);

  explicit inline OwningStringOrSanitizerElementNamespaceWithAttributes(const OwningStringOrSanitizerElementNamespaceWithAttributes& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningStringOrSanitizerElementNamespaceWithAttributes()
  {
    Uninit();
  }

  [[nodiscard]] nsString&
  RawSetAsString();

  [[nodiscard]] nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  [[nodiscard]] SanitizerElementNamespaceWithAttributes&
  RawSetAsSanitizerElementNamespaceWithAttributes();

  [[nodiscard]] SanitizerElementNamespaceWithAttributes&
  SetAsSanitizerElementNamespaceWithAttributes();

  inline bool
  IsSanitizerElementNamespaceWithAttributes() const
  {
    return mType == eSanitizerElementNamespaceWithAttributes;
  }

  inline SanitizerElementNamespaceWithAttributes&
  GetAsSanitizerElementNamespaceWithAttributes()
  {
    MOZ_RELEASE_ASSERT(IsSanitizerElementNamespaceWithAttributes(), "Wrong type!");
    return mValue.mSanitizerElementNamespaceWithAttributes.Value();
  }

  inline SanitizerElementNamespaceWithAttributes const &
  GetAsSanitizerElementNamespaceWithAttributes() const
  {
    MOZ_RELEASE_ASSERT(IsSanitizerElementNamespaceWithAttributes(), "Wrong type!");
    return mValue.mSanitizerElementNamespaceWithAttributes.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  OwningStringOrSanitizerElementNamespaceWithAttributes&
  operator=(OwningStringOrSanitizerElementNamespaceWithAttributes&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningStringOrSanitizerElementNamespaceWithAttributes&
  operator=(const OwningStringOrSanitizerElementNamespaceWithAttributes& aOther);

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();

  bool
  TrySetToSanitizerElementNamespaceWithAttributes(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSanitizerElementNamespaceWithAttributes(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroySanitizerElementNamespaceWithAttributes();
};


struct SanitizerConfig : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<OwningStringOrSanitizerAttributeNamespace>> mAttributes;
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mComments;
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mCustomElements;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<OwningStringOrSanitizerElementNamespaceWithAttributes>> mElements;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<OwningStringOrSanitizerAttributeNamespace>> mRemoveAttributes;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<OwningStringOrSanitizerElementNamespace>> mRemoveElements;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<OwningStringOrSanitizerElementNamespace>> mReplaceWithChildrenElements;
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mUnknownMarkup;

  SanitizerConfig();

  explicit inline SanitizerConfig(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  SanitizerConfig(SanitizerConfig&& aOther) = default;

  explicit inline SanitizerConfig(const SanitizerConfig& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  SanitizerConfig&
  operator=(const SanitizerConfig& aOther);

private:
  static bool
  InitIds(JSContext* cx, SanitizerConfigAtoms* atomsCache);
};

namespace binding_detail {
struct FastSanitizerConfig : public SanitizerConfig
{
  inline FastSanitizerConfig()
    : SanitizerConfig(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace Sanitizer_Binding {

  typedef mozilla::dom::Sanitizer NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::Sanitizer* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::Sanitizer,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::Sanitizer,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::Sanitizer,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace Sanitizer_Binding



} // namespace mozilla::dom

#endif // DOM_SANITIZERBINDING_H_
