// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanToolkitMozappsUpdateBackgroundTaskMetrics_h
#define mozilla_GleanToolkitMozappsUpdateBackgroundTaskMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace background_update {
  /**
   * generated from background_update.automatic_restart_attempted
   * True if the background update task successfully attempted an automatic restart.
   */
  constexpr impl::BooleanMetric automatic_restart_attempted(373);

  /**
   * generated from background_update.automatic_restart_success
   * True if the background update task successfully restarted after an automatic restart.
   */
  constexpr impl::BooleanMetric automatic_restart_success(374);

  /**
   * generated from background_update.client_id
   * The legacy Telemetry client ID of this installation's default profile.
   * The default profile is as determined by the Profile Service, namely `nsIToolkitProfileService.defaultProfile`.  The majority of users have only one Firefox installation and only one profile, so the default profile is their regular browsing profile.
   * It is possible for a Firefox installation to not have a default profile, but in such cases the background update task will abort before sending any telemetry; therefore, the legacy Telemetry client ID should always be present.
   */
  constexpr impl::UuidMetric client_id(375);

  /**
   * generated from background_update.exit_code_exception
   * True if the exit code/status of the background update task is 3, which means an exception was thrown.
   */
  constexpr impl::BooleanMetric exit_code_exception(376);

  /**
   * generated from background_update.exit_code_success
   * True if the exit code/status of the background update task is 0, which means success.
   */
  constexpr impl::BooleanMetric exit_code_success(377);

  /**
   * generated from background_update.final_state
   * String description of the final state the update state machine reached.
   */
  constexpr impl::StringMetric final_state(378);

  /**
   * generated from background_update.reasons
   * List of reasons that the background update task did not run.
   */
  constexpr impl::StringListMetric reasons(379);

  /**
   * generated from background_update.states
   * Ordered list of string descriptions of the states that the update state machine reached.
   */
  constexpr impl::StringListMetric states(380);

  /**
   * generated from background_update.targeting_env_current_date
   * The `environment.currentDate` of the default profile's serialized targeting snapshot.
   */
  constexpr impl::DatetimeMetric targeting_env_current_date(381);

  /**
   * generated from background_update.targeting_env_firefox_version
   * The `environment.firefoxVersion` of the default profile's serialized targeting snapshot.  At the time of writing, this version is an integer representing the Firefox major version, e.g., `109`.
   */
  constexpr impl::QuantityMetric targeting_env_firefox_version(382);

  /**
   * generated from background_update.targeting_env_profile_age
   * The `environment.profileAgeCreated` of the default profile's serialized targeting snapshot.
   */
  constexpr impl::DatetimeMetric targeting_env_profile_age(383);

  /**
   * generated from background_update.targeting_exception
   * True if the default profile had a targeting snapshot serialized to disk, but an exception was thrown reading it.
   */
  constexpr impl::BooleanMetric targeting_exception(384);

  /**
   * generated from background_update.targeting_exists
   * True if the default profile had a targeting snapshot serialized to disk, and there was no exception thrown reading it.
   */
  constexpr impl::BooleanMetric targeting_exists(385);

  /**
   * generated from background_update.targeting_version
   * If the default profile had a targeting snapshot serialized to disk, the `version` of the snapshot.
   * This version number does not have a physical unit: it's only useful to compare between versions.
   */
  constexpr impl::QuantityMetric targeting_version(386);
}

namespace update {
  /**
   * generated from update.auto_download
   * Per-installation preference "app.update.auto": whether to fetch and install updates without user intervention.
   */
  constexpr impl::BooleanMetric auto_download(5803);

  /**
   * generated from update.background_update
   * Per-installation preference "app.update.background.enabled": whether to fetch and install updates in the background when Firefox is not running.
   */
  constexpr impl::BooleanMetric background_update(5804);

  /**
   * generated from update.can_usually_apply_updates
   * Whether or not the Update Service can usually download and install updates. See `canUsuallyApplyUpdates` in https://searchfox.org/mozilla-central/source/toolkit/mozapps/update/nsIUpdateService.idl.
   */
  constexpr impl::BooleanMetric can_usually_apply_updates(5805);

  /**
   * generated from update.can_usually_check_for_updates
   * Whether or not the Update Service can usually check for updates. See `canUsuallyCheckForUpdates` in https://searchfox.org/mozilla-central/source/toolkit/mozapps/update/nsIUpdateService.idl.
   */
  constexpr impl::BooleanMetric can_usually_check_for_updates(5806);

  /**
   * generated from update.can_usually_stage_updates
   * Whether the Update Service is usually able to stage updates. See `canUsuallyStageUpdates` in https://searchfox.org/mozilla-central/source/toolkit/mozapps/update/nsIUpdateService.idl.
   */
  constexpr impl::BooleanMetric can_usually_stage_updates(5807);

  /**
   * generated from update.can_usually_use_bits
   * On Windows, whether the Update Service can usually use BITS. See `canUsuallyUseBits` in https://searchfox.org/mozilla-central/source/toolkit/mozapps/update/nsIUpdateService.idl.
   */
  constexpr impl::BooleanMetric can_usually_use_bits(5808);

  /**
   * generated from update.channel
   * The update channel.
   */
  constexpr impl::StringMetric channel(5809);

  /**
   * generated from update.enabled
   * True when policies are disabled or when the "DisableAppUpdate" is not in effect.
   */
  constexpr impl::BooleanMetric enabled(5810);

  /**
   * generated from update.service_enabled
   * Preference "app.update.service.enabled": whether the Mozilla Maintenance Service is enabled.
   */
  constexpr impl::BooleanMetric service_enabled(5811);
}

} // namespace mozilla::glean

#endif // mozilla_GleanToolkitMozappsUpdateBackgroundTaskMetrics_h
