/* THIS FILE IS AUTOGENERATED FROM LockManager.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_LOCKMANAGERBINDING_H_
#define DOM_LOCKMANAGERBINDING_H_

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/EnumTypeTraits.h"
#include "mozilla/Span.h"
#include "mozilla/dom/AbortSignal.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/ToJSValue.h"
#include "nsCycleCollectionParticipant.h"

namespace mozilla {
namespace dom {

class AbortSignal;
class Lock;
class LockGrantedCallback;
struct LockInfo;
struct LockInfoAtoms;
class LockManager;
struct LockManagerSnapshotAtoms;
struct LockOptionsAtoms;
struct NativePropertyHooks;
class Promise;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla {

namespace dom {

enum class LockMode : uint8_t {
  Shared,
  Exclusive,
};

namespace binding_detail {
template <> struct EnumStrings<LockMode> {
  static constexpr nsLiteralCString Values[2] {
    "shared"_ns,
    "exclusive"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, LockMode aArgument, JS::MutableHandle<JS::Value> aValue);


class LockGrantedCallback : public CallbackFunction
{
public:
  explicit inline LockGrantedCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline LockGrantedCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline LockGrantedCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline LockGrantedCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline already_AddRefed<Promise>
  Call(const T& thisVal, Lock* lock, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "LockGrantedCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return nullptr;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return nullptr;
    }
    return Call(s.GetCallContext(), thisValJS, lock, aRv);
  }

  MOZ_CAN_RUN_SCRIPT inline already_AddRefed<Promise>
  Call(Lock* lock, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "LockGrantedCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return nullptr;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, lock, aRv);
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline already_AddRefed<Promise>
  Call(const T& thisVal, Lock* lock, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, lock, IgnoreErrors(), aExecutionReason);
  }

  MOZ_CAN_RUN_SCRIPT inline already_AddRefed<Promise>
  Call(Lock* lock, const char* aExecutionReason = nullptr)
  {
    return Call(lock, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const LockGrantedCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  MOZ_CAN_RUN_SCRIPT already_AddRefed<Promise> Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, Lock* lock, ErrorResult& aRv);
};


namespace binding_detail {
class FastLockGrantedCallback : public LockGrantedCallback
{
public:
  explicit inline FastLockGrantedCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : LockGrantedCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    LockGrantedCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    LockGrantedCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


struct LockInfo : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mClientId;
  MOZ_INIT_OUTSIDE_CTOR Optional<LockMode> mMode;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mName;

  LockInfo();

  explicit inline LockInfo(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  LockInfo(LockInfo&& aOther) = default;

  explicit inline LockInfo(const LockInfo& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  LockInfo&
  operator=(const LockInfo& aOther);

private:
  static bool
  InitIds(JSContext* cx, LockInfoAtoms* atomsCache);
};

namespace binding_detail {
struct FastLockInfo : public LockInfo
{
  inline FastLockInfo()
    : LockInfo(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct LockOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mIfAvailable;
  MOZ_INIT_OUTSIDE_CTOR LockMode mMode;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningNonNull<mozilla::dom::AbortSignal>> mSignal;
  MOZ_INIT_OUTSIDE_CTOR bool mSteal;

  LockOptions();

  explicit inline LockOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  LockOptions(LockOptions&& aOther) = default;

  explicit inline LockOptions(const LockOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mSignal, "mSignal", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mSignal);
  }

  LockOptions&
  operator=(const LockOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, LockOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastLockOptions : public LockOptions
{
  inline FastLockOptions()
    : LockOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct LockManagerSnapshot : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<LockInfo>> mHeld;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<LockInfo>> mPending;

  LockManagerSnapshot();

  explicit inline LockManagerSnapshot(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  LockManagerSnapshot(LockManagerSnapshot&& aOther) = default;

  explicit inline LockManagerSnapshot(const LockManagerSnapshot& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  LockManagerSnapshot&
  operator=(const LockManagerSnapshot& aOther);

private:
  static bool
  InitIds(JSContext* cx, LockManagerSnapshotAtoms* atomsCache);
};

namespace binding_detail {
struct FastLockManagerSnapshot : public LockManagerSnapshot
{
  inline FastLockManagerSnapshot()
    : LockManagerSnapshot(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace LockManager_Binding {

  typedef mozilla::dom::LockManager NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::LockManager* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::LockManager,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace LockManager_Binding



} // namespace dom


template <>
struct MaxContiguousEnumValue<dom::LockMode>
{
  static constexpr dom::LockMode value = dom::LockMode::Exclusive;

  static_assert(static_cast<uint8_t>(dom::LockMode::Shared) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::LockMode>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};


} // namespace mozilla

#endif // DOM_LOCKMANAGERBINDING_H_
