/* THIS FILE IS AUTOGENERATED FROM Performance.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_PERFORMANCEBINDING_H_
#define DOM_PERFORMANCEBINDING_H_

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/RootedDictionary.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

struct NativePropertyHooks;
class OwningStringOrDouble;
class Performance;
struct PerformanceMarkOptionsAtoms;
struct PerformanceMeasureOptionsAtoms;
class ProtoAndIfaceCache;
class StringOrDouble;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

struct PerformanceMarkOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR JS::Value mDetail;
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mStartTime;

  PerformanceMarkOptions();

  explicit inline PerformanceMarkOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  PerformanceMarkOptions(PerformanceMarkOptions&& aOther) = default;

private:
  PerformanceMarkOptions(const PerformanceMarkOptions&) = delete;
  PerformanceMarkOptions& operator=(const PerformanceMarkOptions&) = delete;

  static bool
  InitIds(JSContext* cx, PerformanceMarkOptionsAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastPerformanceMarkOptions : public PerformanceMarkOptions
{
  inline FastPerformanceMarkOptions()
    : PerformanceMarkOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class StringOrDouble : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eDouble
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eDouble = TypeOrUninit::eDouble
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char16_t> > mString;
    UnionMember<double > mDouble;

  };

  TypeOrUninit mType;
  Value mValue;

  StringOrDouble(const StringOrDouble&) = delete;
  StringOrDouble& operator=(const StringOrDouble&) = delete;
public:
  explicit inline StringOrDouble()
    : mType(eUninitialized)
  {
  }

  inline ~StringOrDouble()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  [[nodiscard]] inline double&
  RawSetAsDouble()
  {
    if (mType == eDouble) {
      return mValue.mDouble.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDouble;
    return mValue.mDouble.SetValue();
  }

  [[nodiscard]] inline double&
  SetAsDouble()
  {
    if (mType == eDouble) {
      return mValue.mDouble.Value();
    }
    Uninit();
    mType = eDouble;
    return mValue.mDouble.SetValue();
  }

  inline bool
  IsDouble() const
  {
    return mType == eDouble;
  }

  inline double&
  GetAsDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline double
  GetAsDouble() const
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
      case eDouble: {
        DestroyDouble();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToDouble(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDouble(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    mValue.mDouble.Destroy();
    mType = eUninitialized;
  }
};


class OwningStringOrDouble : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eDouble
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eDouble = TypeOrUninit::eDouble
  };

private:
  union Value
  {
    UnionMember<nsString > mString;
    UnionMember<double > mDouble;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningStringOrDouble()
    : mType(eUninitialized)
  {
  }

  OwningStringOrDouble(OwningStringOrDouble&& aOther);

  explicit inline OwningStringOrDouble(const OwningStringOrDouble& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningStringOrDouble()
  {
    Uninit();
  }

  [[nodiscard]] nsString&
  RawSetAsString();

  [[nodiscard]] nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  [[nodiscard]] double&
  RawSetAsDouble();

  [[nodiscard]] double&
  SetAsDouble();

  inline bool
  IsDouble() const
  {
    return mType == eDouble;
  }

  inline double&
  GetAsDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline double const &
  GetAsDouble() const
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningStringOrDouble&
  operator=(OwningStringOrDouble&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningStringOrDouble&
  operator=(const OwningStringOrDouble& aOther);

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();

  bool
  TrySetToDouble(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDouble(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyDouble();
};


struct PerformanceMeasureOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR JS::Value mDetail;
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mDuration;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningStringOrDouble> mEnd;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningStringOrDouble> mStart;

  PerformanceMeasureOptions();

  explicit inline PerformanceMeasureOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  PerformanceMeasureOptions(PerformanceMeasureOptions&& aOther) = default;

private:
  PerformanceMeasureOptions(const PerformanceMeasureOptions&) = delete;
  PerformanceMeasureOptions& operator=(const PerformanceMeasureOptions&) = delete;

  static bool
  InitIds(JSContext* cx, PerformanceMeasureOptionsAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastPerformanceMeasureOptions : public PerformanceMeasureOptions
{
  inline FastPerformanceMeasureOptions()
    : PerformanceMeasureOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class StringOrPerformanceMeasureOptions : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    ePerformanceMeasureOptions
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    ePerformanceMeasureOptions = TypeOrUninit::ePerformanceMeasureOptions
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char16_t> > mString;
    UnionMember<RootedDictionary<binding_detail::FastPerformanceMeasureOptions> > mPerformanceMeasureOptions;

  };

  TypeOrUninit mType;
  Value mValue;

  StringOrPerformanceMeasureOptions(const StringOrPerformanceMeasureOptions&) = delete;
  StringOrPerformanceMeasureOptions& operator=(const StringOrPerformanceMeasureOptions&) = delete;
public:
  explicit inline StringOrPerformanceMeasureOptions()
    : mType(eUninitialized)
  {
  }

  inline ~StringOrPerformanceMeasureOptions()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  [[nodiscard]] inline RootedDictionary<binding_detail::FastPerformanceMeasureOptions>&
  RawSetAsPerformanceMeasureOptions(JSContext* cx)
  {
    if (mType == ePerformanceMeasureOptions) {
      return mValue.mPerformanceMeasureOptions.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = ePerformanceMeasureOptions;
    return mValue.mPerformanceMeasureOptions.SetValue(cx);
  }

  [[nodiscard]] inline RootedDictionary<binding_detail::FastPerformanceMeasureOptions>&
  SetAsPerformanceMeasureOptions(JSContext* cx)
  {
    if (mType == ePerformanceMeasureOptions) {
      return mValue.mPerformanceMeasureOptions.Value();
    }
    Uninit();
    mType = ePerformanceMeasureOptions;
    return mValue.mPerformanceMeasureOptions.SetValue(cx);
  }

  inline bool
  IsPerformanceMeasureOptions() const
  {
    return mType == ePerformanceMeasureOptions;
  }

  inline RootedDictionary<binding_detail::FastPerformanceMeasureOptions>&
  GetAsPerformanceMeasureOptions()
  {
    MOZ_RELEASE_ASSERT(IsPerformanceMeasureOptions(), "Wrong type!");
    return mValue.mPerformanceMeasureOptions.Value();
  }

  inline const PerformanceMeasureOptions&
  GetAsPerformanceMeasureOptions() const
  {
    MOZ_RELEASE_ASSERT(IsPerformanceMeasureOptions(), "Wrong type!");
    return mValue.mPerformanceMeasureOptions.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
      case ePerformanceMeasureOptions: {
        DestroyPerformanceMeasureOptions();
        break;
      }
    }
  }

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToPerformanceMeasureOptions(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToPerformanceMeasureOptions(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyPerformanceMeasureOptions()
  {
    MOZ_RELEASE_ASSERT(IsPerformanceMeasureOptions(), "Wrong type!");
    mValue.mPerformanceMeasureOptions.Destroy();
    mType = eUninitialized;
  }
};


class OwningStringOrPerformanceMeasureOptions : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    ePerformanceMeasureOptions
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    ePerformanceMeasureOptions = TypeOrUninit::ePerformanceMeasureOptions
  };

private:
  union Value
  {
    UnionMember<nsString > mString;
    UnionMember<PerformanceMeasureOptions > mPerformanceMeasureOptions;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningStringOrPerformanceMeasureOptions(const OwningStringOrPerformanceMeasureOptions&) = delete;
  OwningStringOrPerformanceMeasureOptions& operator=(const OwningStringOrPerformanceMeasureOptions&) = delete;
public:
  explicit inline OwningStringOrPerformanceMeasureOptions()
    : mType(eUninitialized)
  {
  }

  OwningStringOrPerformanceMeasureOptions(OwningStringOrPerformanceMeasureOptions&& aOther);

  inline ~OwningStringOrPerformanceMeasureOptions()
  {
    Uninit();
  }

  [[nodiscard]] nsString&
  RawSetAsString();

  [[nodiscard]] nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  [[nodiscard]] PerformanceMeasureOptions&
  RawSetAsPerformanceMeasureOptions();

  [[nodiscard]] PerformanceMeasureOptions&
  SetAsPerformanceMeasureOptions();

  inline bool
  IsPerformanceMeasureOptions() const
  {
    return mType == ePerformanceMeasureOptions;
  }

  inline PerformanceMeasureOptions&
  GetAsPerformanceMeasureOptions()
  {
    MOZ_RELEASE_ASSERT(IsPerformanceMeasureOptions(), "Wrong type!");
    return mValue.mPerformanceMeasureOptions.Value();
  }

  inline PerformanceMeasureOptions const &
  GetAsPerformanceMeasureOptions() const
  {
    MOZ_RELEASE_ASSERT(IsPerformanceMeasureOptions(), "Wrong type!");
    return mValue.mPerformanceMeasureOptions.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  void
  TraceUnion(JSTracer* trc);

  OwningStringOrPerformanceMeasureOptions&
  operator=(OwningStringOrPerformanceMeasureOptions&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();

  bool
  TrySetToPerformanceMeasureOptions(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToPerformanceMeasureOptions(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyPerformanceMeasureOptions();
};


namespace Performance_Binding {

  typedef mozilla::dom::Performance NativeType;

  MOZ_CAN_RUN_SCRIPT bool
  CollectJSONAttributes(JSContext* cx, JS::Handle<JSObject*> obj, mozilla::dom::Performance* self, JS::Rooted<JSObject*>& result);

  bool
  Wrap(JSContext* aCx, mozilla::dom::Performance* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::Performance,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace Performance_Binding



} // namespace mozilla::dom

#endif // DOM_PERFORMANCEBINDING_H_
