/* THIS FILE IS AUTOGENERATED FROM Sanitizer.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_SANITIZERBINDING_H_
#define DOM_SANITIZERBINDING_H_

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/EnumTypeTraits.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"
#include "nsCycleCollectionParticipant.h"

namespace mozilla {
namespace dom {

struct NativePropertyHooks;
class OwningSanitizerOrSanitizerConfigOrSanitizerPresets;
class OwningStringOrSanitizerAttributeNamespace;
class OwningStringOrSanitizerElementNamespace;
class OwningStringOrSanitizerElementNamespaceWithAttributes;
class ProtoAndIfaceCache;
class Sanitizer;
struct SanitizerAttributeNamespaceAtoms;
struct SanitizerConfigAtoms;
struct SanitizerElementNamespaceAtoms;
struct SanitizerElementNamespaceWithAttributesAtoms;
class SanitizerOrSanitizerConfigOrSanitizerPresets;
struct SetHTMLOptionsAtoms;
struct SetHTMLUnsafeOptionsAtoms;
class StringOrSanitizerAttributeNamespace;
class StringOrSanitizerElementNamespace;
class StringOrSanitizerElementNamespaceWithAttributes;

} // namespace dom
} // namespace mozilla

namespace mozilla {

namespace dom {

enum class SanitizerPresets : uint8_t {
  Default,
};

namespace binding_detail {
template <> struct EnumStrings<SanitizerPresets> {
  static constexpr nsLiteralCString Values[1] {
    "default"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, SanitizerPresets aArgument, JS::MutableHandle<JS::Value> aValue);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningSanitizerOrSanitizerConfigOrSanitizerPresets& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningSanitizerOrSanitizerConfigOrSanitizerPresets& aUnion);


struct SanitizerAttributeNamespace : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mName;
  MOZ_INIT_OUTSIDE_CTOR nsString mNamespace;

  SanitizerAttributeNamespace();

  explicit inline SanitizerAttributeNamespace(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  SanitizerAttributeNamespace(SanitizerAttributeNamespace&& aOther) = default;

  explicit inline SanitizerAttributeNamespace(const SanitizerAttributeNamespace& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  SanitizerAttributeNamespace&
  operator=(const SanitizerAttributeNamespace& aOther);

private:
  static bool
  InitIds(JSContext* cx, SanitizerAttributeNamespaceAtoms* atomsCache);
};

namespace binding_detail {
struct FastSanitizerAttributeNamespace : public SanitizerAttributeNamespace
{
  inline FastSanitizerAttributeNamespace()
    : SanitizerAttributeNamespace(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct SanitizerElementNamespace : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mName;
  MOZ_INIT_OUTSIDE_CTOR nsString mNamespace;

  SanitizerElementNamespace();

  explicit inline SanitizerElementNamespace(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  SanitizerElementNamespace(SanitizerElementNamespace&& aOther) = default;

  explicit inline SanitizerElementNamespace(const SanitizerElementNamespace& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  SanitizerElementNamespace&
  operator=(const SanitizerElementNamespace& aOther);

private:
  static bool
  InitIds(JSContext* cx, SanitizerElementNamespaceAtoms* atomsCache);
};

namespace binding_detail {
struct FastSanitizerElementNamespace : public SanitizerElementNamespace
{
  inline FastSanitizerElementNamespace()
    : SanitizerElementNamespace(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class StringOrSanitizerAttributeNamespace : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eSanitizerAttributeNamespace
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eSanitizerAttributeNamespace = TypeOrUninit::eSanitizerAttributeNamespace
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char16_t> > mString;
    UnionMember<binding_detail::FastSanitizerAttributeNamespace > mSanitizerAttributeNamespace;

  };

  TypeOrUninit mType;
  Value mValue;

  StringOrSanitizerAttributeNamespace(const StringOrSanitizerAttributeNamespace&) = delete;
  StringOrSanitizerAttributeNamespace& operator=(const StringOrSanitizerAttributeNamespace&) = delete;
public:
  explicit inline StringOrSanitizerAttributeNamespace()
    : mType(eUninitialized)
  {
  }

  inline ~StringOrSanitizerAttributeNamespace()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  [[nodiscard]] inline binding_detail::FastSanitizerAttributeNamespace&
  RawSetAsSanitizerAttributeNamespace()
  {
    if (mType == eSanitizerAttributeNamespace) {
      return mValue.mSanitizerAttributeNamespace.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eSanitizerAttributeNamespace;
    return mValue.mSanitizerAttributeNamespace.SetValue();
  }

  [[nodiscard]] inline binding_detail::FastSanitizerAttributeNamespace&
  SetAsSanitizerAttributeNamespace()
  {
    if (mType == eSanitizerAttributeNamespace) {
      return mValue.mSanitizerAttributeNamespace.Value();
    }
    Uninit();
    mType = eSanitizerAttributeNamespace;
    return mValue.mSanitizerAttributeNamespace.SetValue();
  }

  inline bool
  IsSanitizerAttributeNamespace() const
  {
    return mType == eSanitizerAttributeNamespace;
  }

  inline binding_detail::FastSanitizerAttributeNamespace&
  GetAsSanitizerAttributeNamespace()
  {
    MOZ_RELEASE_ASSERT(IsSanitizerAttributeNamespace(), "Wrong type!");
    return mValue.mSanitizerAttributeNamespace.Value();
  }

  inline const SanitizerAttributeNamespace&
  GetAsSanitizerAttributeNamespace() const
  {
    MOZ_RELEASE_ASSERT(IsSanitizerAttributeNamespace(), "Wrong type!");
    return mValue.mSanitizerAttributeNamespace.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
      case eSanitizerAttributeNamespace: {
        DestroySanitizerAttributeNamespace();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToSanitizerAttributeNamespace(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSanitizerAttributeNamespace(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroySanitizerAttributeNamespace()
  {
    MOZ_RELEASE_ASSERT(IsSanitizerAttributeNamespace(), "Wrong type!");
    mValue.mSanitizerAttributeNamespace.Destroy();
    mType = eUninitialized;
  }
};


class OwningStringOrSanitizerAttributeNamespace : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eSanitizerAttributeNamespace
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eSanitizerAttributeNamespace = TypeOrUninit::eSanitizerAttributeNamespace
  };

private:
  union Value
  {
    UnionMember<nsString > mString;
    UnionMember<SanitizerAttributeNamespace > mSanitizerAttributeNamespace;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningStringOrSanitizerAttributeNamespace()
    : mType(eUninitialized)
  {
  }

  OwningStringOrSanitizerAttributeNamespace(OwningStringOrSanitizerAttributeNamespace&& aOther);

  explicit inline OwningStringOrSanitizerAttributeNamespace(const OwningStringOrSanitizerAttributeNamespace& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningStringOrSanitizerAttributeNamespace()
  {
    Uninit();
  }

  [[nodiscard]] nsString&
  RawSetAsString();

  [[nodiscard]] nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  [[nodiscard]] SanitizerAttributeNamespace&
  RawSetAsSanitizerAttributeNamespace();

  [[nodiscard]] SanitizerAttributeNamespace&
  SetAsSanitizerAttributeNamespace();

  inline bool
  IsSanitizerAttributeNamespace() const
  {
    return mType == eSanitizerAttributeNamespace;
  }

  inline SanitizerAttributeNamespace&
  GetAsSanitizerAttributeNamespace()
  {
    MOZ_RELEASE_ASSERT(IsSanitizerAttributeNamespace(), "Wrong type!");
    return mValue.mSanitizerAttributeNamespace.Value();
  }

  inline SanitizerAttributeNamespace const &
  GetAsSanitizerAttributeNamespace() const
  {
    MOZ_RELEASE_ASSERT(IsSanitizerAttributeNamespace(), "Wrong type!");
    return mValue.mSanitizerAttributeNamespace.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningStringOrSanitizerAttributeNamespace&
  operator=(OwningStringOrSanitizerAttributeNamespace&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningStringOrSanitizerAttributeNamespace&
  operator=(const OwningStringOrSanitizerAttributeNamespace& aOther);

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();

  bool
  TrySetToSanitizerAttributeNamespace(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSanitizerAttributeNamespace(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroySanitizerAttributeNamespace();
};


class StringOrSanitizerElementNamespace : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eSanitizerElementNamespace
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eSanitizerElementNamespace = TypeOrUninit::eSanitizerElementNamespace
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char16_t> > mString;
    UnionMember<binding_detail::FastSanitizerElementNamespace > mSanitizerElementNamespace;

  };

  TypeOrUninit mType;
  Value mValue;

  StringOrSanitizerElementNamespace(const StringOrSanitizerElementNamespace&) = delete;
  StringOrSanitizerElementNamespace& operator=(const StringOrSanitizerElementNamespace&) = delete;
public:
  explicit inline StringOrSanitizerElementNamespace()
    : mType(eUninitialized)
  {
  }

  inline ~StringOrSanitizerElementNamespace()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  [[nodiscard]] inline binding_detail::FastSanitizerElementNamespace&
  RawSetAsSanitizerElementNamespace()
  {
    if (mType == eSanitizerElementNamespace) {
      return mValue.mSanitizerElementNamespace.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eSanitizerElementNamespace;
    return mValue.mSanitizerElementNamespace.SetValue();
  }

  [[nodiscard]] inline binding_detail::FastSanitizerElementNamespace&
  SetAsSanitizerElementNamespace()
  {
    if (mType == eSanitizerElementNamespace) {
      return mValue.mSanitizerElementNamespace.Value();
    }
    Uninit();
    mType = eSanitizerElementNamespace;
    return mValue.mSanitizerElementNamespace.SetValue();
  }

  inline bool
  IsSanitizerElementNamespace() const
  {
    return mType == eSanitizerElementNamespace;
  }

  inline binding_detail::FastSanitizerElementNamespace&
  GetAsSanitizerElementNamespace()
  {
    MOZ_RELEASE_ASSERT(IsSanitizerElementNamespace(), "Wrong type!");
    return mValue.mSanitizerElementNamespace.Value();
  }

  inline const SanitizerElementNamespace&
  GetAsSanitizerElementNamespace() const
  {
    MOZ_RELEASE_ASSERT(IsSanitizerElementNamespace(), "Wrong type!");
    return mValue.mSanitizerElementNamespace.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
      case eSanitizerElementNamespace: {
        DestroySanitizerElementNamespace();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToSanitizerElementNamespace(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSanitizerElementNamespace(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroySanitizerElementNamespace()
  {
    MOZ_RELEASE_ASSERT(IsSanitizerElementNamespace(), "Wrong type!");
    mValue.mSanitizerElementNamespace.Destroy();
    mType = eUninitialized;
  }
};


class OwningStringOrSanitizerElementNamespace : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eSanitizerElementNamespace
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eSanitizerElementNamespace = TypeOrUninit::eSanitizerElementNamespace
  };

private:
  union Value
  {
    UnionMember<nsString > mString;
    UnionMember<SanitizerElementNamespace > mSanitizerElementNamespace;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningStringOrSanitizerElementNamespace()
    : mType(eUninitialized)
  {
  }

  OwningStringOrSanitizerElementNamespace(OwningStringOrSanitizerElementNamespace&& aOther);

  explicit inline OwningStringOrSanitizerElementNamespace(const OwningStringOrSanitizerElementNamespace& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningStringOrSanitizerElementNamespace()
  {
    Uninit();
  }

  [[nodiscard]] nsString&
  RawSetAsString();

  [[nodiscard]] nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  [[nodiscard]] SanitizerElementNamespace&
  RawSetAsSanitizerElementNamespace();

  [[nodiscard]] SanitizerElementNamespace&
  SetAsSanitizerElementNamespace();

  inline bool
  IsSanitizerElementNamespace() const
  {
    return mType == eSanitizerElementNamespace;
  }

  inline SanitizerElementNamespace&
  GetAsSanitizerElementNamespace()
  {
    MOZ_RELEASE_ASSERT(IsSanitizerElementNamespace(), "Wrong type!");
    return mValue.mSanitizerElementNamespace.Value();
  }

  inline SanitizerElementNamespace const &
  GetAsSanitizerElementNamespace() const
  {
    MOZ_RELEASE_ASSERT(IsSanitizerElementNamespace(), "Wrong type!");
    return mValue.mSanitizerElementNamespace.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningStringOrSanitizerElementNamespace&
  operator=(OwningStringOrSanitizerElementNamespace&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningStringOrSanitizerElementNamespace&
  operator=(const OwningStringOrSanitizerElementNamespace& aOther);

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();

  bool
  TrySetToSanitizerElementNamespace(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSanitizerElementNamespace(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroySanitizerElementNamespace();
};


struct SanitizerElementNamespaceWithAttributes : public SanitizerElementNamespace
{
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<OwningStringOrSanitizerAttributeNamespace>> mAttributes;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<OwningStringOrSanitizerAttributeNamespace>> mRemoveAttributes;

  SanitizerElementNamespaceWithAttributes();

  explicit inline SanitizerElementNamespaceWithAttributes(const FastDictionaryInitializer& )
    : SanitizerElementNamespace(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  SanitizerElementNamespaceWithAttributes(SanitizerElementNamespaceWithAttributes&& aOther) = default;

  explicit inline SanitizerElementNamespaceWithAttributes(const SanitizerElementNamespaceWithAttributes& aOther)
    : SanitizerElementNamespace(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  SanitizerElementNamespaceWithAttributes&
  operator=(const SanitizerElementNamespaceWithAttributes& aOther);

private:
  static bool
  InitIds(JSContext* cx, SanitizerElementNamespaceWithAttributesAtoms* atomsCache);
};

namespace binding_detail {
struct FastSanitizerElementNamespaceWithAttributes : public SanitizerElementNamespaceWithAttributes
{
  inline FastSanitizerElementNamespaceWithAttributes()
    : SanitizerElementNamespaceWithAttributes(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class StringOrSanitizerElementNamespaceWithAttributes : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eSanitizerElementNamespaceWithAttributes
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eSanitizerElementNamespaceWithAttributes = TypeOrUninit::eSanitizerElementNamespaceWithAttributes
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char16_t> > mString;
    UnionMember<binding_detail::FastSanitizerElementNamespaceWithAttributes > mSanitizerElementNamespaceWithAttributes;

  };

  TypeOrUninit mType;
  Value mValue;

  StringOrSanitizerElementNamespaceWithAttributes(const StringOrSanitizerElementNamespaceWithAttributes&) = delete;
  StringOrSanitizerElementNamespaceWithAttributes& operator=(const StringOrSanitizerElementNamespaceWithAttributes&) = delete;
public:
  explicit inline StringOrSanitizerElementNamespaceWithAttributes()
    : mType(eUninitialized)
  {
  }

  inline ~StringOrSanitizerElementNamespaceWithAttributes()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  [[nodiscard]] inline binding_detail::FastSanitizerElementNamespaceWithAttributes&
  RawSetAsSanitizerElementNamespaceWithAttributes()
  {
    if (mType == eSanitizerElementNamespaceWithAttributes) {
      return mValue.mSanitizerElementNamespaceWithAttributes.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eSanitizerElementNamespaceWithAttributes;
    return mValue.mSanitizerElementNamespaceWithAttributes.SetValue();
  }

  [[nodiscard]] inline binding_detail::FastSanitizerElementNamespaceWithAttributes&
  SetAsSanitizerElementNamespaceWithAttributes()
  {
    if (mType == eSanitizerElementNamespaceWithAttributes) {
      return mValue.mSanitizerElementNamespaceWithAttributes.Value();
    }
    Uninit();
    mType = eSanitizerElementNamespaceWithAttributes;
    return mValue.mSanitizerElementNamespaceWithAttributes.SetValue();
  }

  inline bool
  IsSanitizerElementNamespaceWithAttributes() const
  {
    return mType == eSanitizerElementNamespaceWithAttributes;
  }

  inline binding_detail::FastSanitizerElementNamespaceWithAttributes&
  GetAsSanitizerElementNamespaceWithAttributes()
  {
    MOZ_RELEASE_ASSERT(IsSanitizerElementNamespaceWithAttributes(), "Wrong type!");
    return mValue.mSanitizerElementNamespaceWithAttributes.Value();
  }

  inline const SanitizerElementNamespaceWithAttributes&
  GetAsSanitizerElementNamespaceWithAttributes() const
  {
    MOZ_RELEASE_ASSERT(IsSanitizerElementNamespaceWithAttributes(), "Wrong type!");
    return mValue.mSanitizerElementNamespaceWithAttributes.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
      case eSanitizerElementNamespaceWithAttributes: {
        DestroySanitizerElementNamespaceWithAttributes();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToSanitizerElementNamespaceWithAttributes(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSanitizerElementNamespaceWithAttributes(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroySanitizerElementNamespaceWithAttributes()
  {
    MOZ_RELEASE_ASSERT(IsSanitizerElementNamespaceWithAttributes(), "Wrong type!");
    mValue.mSanitizerElementNamespaceWithAttributes.Destroy();
    mType = eUninitialized;
  }
};


class OwningStringOrSanitizerElementNamespaceWithAttributes : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eSanitizerElementNamespaceWithAttributes
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eSanitizerElementNamespaceWithAttributes = TypeOrUninit::eSanitizerElementNamespaceWithAttributes
  };

private:
  union Value
  {
    UnionMember<nsString > mString;
    UnionMember<SanitizerElementNamespaceWithAttributes > mSanitizerElementNamespaceWithAttributes;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningStringOrSanitizerElementNamespaceWithAttributes()
    : mType(eUninitialized)
  {
  }

  OwningStringOrSanitizerElementNamespaceWithAttributes(OwningStringOrSanitizerElementNamespaceWithAttributes&& aOther);

  explicit inline OwningStringOrSanitizerElementNamespaceWithAttributes(const OwningStringOrSanitizerElementNamespaceWithAttributes& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningStringOrSanitizerElementNamespaceWithAttributes()
  {
    Uninit();
  }

  [[nodiscard]] nsString&
  RawSetAsString();

  [[nodiscard]] nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  [[nodiscard]] SanitizerElementNamespaceWithAttributes&
  RawSetAsSanitizerElementNamespaceWithAttributes();

  [[nodiscard]] SanitizerElementNamespaceWithAttributes&
  SetAsSanitizerElementNamespaceWithAttributes();

  inline bool
  IsSanitizerElementNamespaceWithAttributes() const
  {
    return mType == eSanitizerElementNamespaceWithAttributes;
  }

  inline SanitizerElementNamespaceWithAttributes&
  GetAsSanitizerElementNamespaceWithAttributes()
  {
    MOZ_RELEASE_ASSERT(IsSanitizerElementNamespaceWithAttributes(), "Wrong type!");
    return mValue.mSanitizerElementNamespaceWithAttributes.Value();
  }

  inline SanitizerElementNamespaceWithAttributes const &
  GetAsSanitizerElementNamespaceWithAttributes() const
  {
    MOZ_RELEASE_ASSERT(IsSanitizerElementNamespaceWithAttributes(), "Wrong type!");
    return mValue.mSanitizerElementNamespaceWithAttributes.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningStringOrSanitizerElementNamespaceWithAttributes&
  operator=(OwningStringOrSanitizerElementNamespaceWithAttributes&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningStringOrSanitizerElementNamespaceWithAttributes&
  operator=(const OwningStringOrSanitizerElementNamespaceWithAttributes& aOther);

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();

  bool
  TrySetToSanitizerElementNamespaceWithAttributes(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSanitizerElementNamespaceWithAttributes(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroySanitizerElementNamespaceWithAttributes();
};


struct SanitizerConfig : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<OwningStringOrSanitizerAttributeNamespace>> mAttributes;
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mComments;
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mDataAttributes;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<OwningStringOrSanitizerElementNamespaceWithAttributes>> mElements;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<OwningStringOrSanitizerAttributeNamespace>> mRemoveAttributes;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<OwningStringOrSanitizerElementNamespace>> mRemoveElements;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<OwningStringOrSanitizerElementNamespace>> mReplaceWithChildrenElements;

  SanitizerConfig();

  explicit inline SanitizerConfig(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  SanitizerConfig(SanitizerConfig&& aOther) = default;

  explicit inline SanitizerConfig(const SanitizerConfig& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  SanitizerConfig&
  operator=(const SanitizerConfig& aOther);

private:
  static bool
  InitIds(JSContext* cx, SanitizerConfigAtoms* atomsCache);
};

namespace binding_detail {
struct FastSanitizerConfig : public SanitizerConfig
{
  inline FastSanitizerConfig()
    : SanitizerConfig(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class SanitizerConfigOrSanitizerPresets : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eSanitizerConfig,
    eSanitizerPresets
  };
public:
  enum class Type
  {
    eSanitizerConfig = TypeOrUninit::eSanitizerConfig,
    eSanitizerPresets = TypeOrUninit::eSanitizerPresets
  };

private:
  union Value
  {
    UnionMember<binding_detail::FastSanitizerConfig > mSanitizerConfig;
    UnionMember<SanitizerPresets > mSanitizerPresets;

  };

  TypeOrUninit mType;
  Value mValue;

  SanitizerConfigOrSanitizerPresets(const SanitizerConfigOrSanitizerPresets&) = delete;
  SanitizerConfigOrSanitizerPresets& operator=(const SanitizerConfigOrSanitizerPresets&) = delete;
public:
  explicit inline SanitizerConfigOrSanitizerPresets()
    : mType(eUninitialized)
  {
  }

  inline ~SanitizerConfigOrSanitizerPresets()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::FastSanitizerConfig&
  RawSetAsSanitizerConfig()
  {
    if (mType == eSanitizerConfig) {
      return mValue.mSanitizerConfig.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eSanitizerConfig;
    return mValue.mSanitizerConfig.SetValue();
  }

  [[nodiscard]] inline binding_detail::FastSanitizerConfig&
  SetAsSanitizerConfig()
  {
    if (mType == eSanitizerConfig) {
      return mValue.mSanitizerConfig.Value();
    }
    Uninit();
    mType = eSanitizerConfig;
    return mValue.mSanitizerConfig.SetValue();
  }

  inline bool
  IsSanitizerConfig() const
  {
    return mType == eSanitizerConfig;
  }

  inline binding_detail::FastSanitizerConfig&
  GetAsSanitizerConfig()
  {
    MOZ_RELEASE_ASSERT(IsSanitizerConfig(), "Wrong type!");
    return mValue.mSanitizerConfig.Value();
  }

  inline const SanitizerConfig&
  GetAsSanitizerConfig() const
  {
    MOZ_RELEASE_ASSERT(IsSanitizerConfig(), "Wrong type!");
    return mValue.mSanitizerConfig.Value();
  }

  [[nodiscard]] inline SanitizerPresets&
  RawSetAsSanitizerPresets()
  {
    if (mType == eSanitizerPresets) {
      return mValue.mSanitizerPresets.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eSanitizerPresets;
    return mValue.mSanitizerPresets.SetValue();
  }

  [[nodiscard]] inline SanitizerPresets&
  SetAsSanitizerPresets()
  {
    if (mType == eSanitizerPresets) {
      return mValue.mSanitizerPresets.Value();
    }
    Uninit();
    mType = eSanitizerPresets;
    return mValue.mSanitizerPresets.SetValue();
  }

  inline bool
  IsSanitizerPresets() const
  {
    return mType == eSanitizerPresets;
  }

  inline SanitizerPresets&
  GetAsSanitizerPresets()
  {
    MOZ_RELEASE_ASSERT(IsSanitizerPresets(), "Wrong type!");
    return mValue.mSanitizerPresets.Value();
  }

  inline SanitizerPresets
  GetAsSanitizerPresets() const
  {
    MOZ_RELEASE_ASSERT(IsSanitizerPresets(), "Wrong type!");
    return mValue.mSanitizerPresets.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eSanitizerConfig: {
        DestroySanitizerConfig();
        break;
      }
      case eSanitizerPresets: {
        DestroySanitizerPresets();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToSanitizerConfig(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSanitizerConfig(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroySanitizerConfig()
  {
    MOZ_RELEASE_ASSERT(IsSanitizerConfig(), "Wrong type!");
    mValue.mSanitizerConfig.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToSanitizerPresets(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSanitizerPresets(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroySanitizerPresets()
  {
    MOZ_RELEASE_ASSERT(IsSanitizerPresets(), "Wrong type!");
    mValue.mSanitizerPresets.Destroy();
    mType = eUninitialized;
  }
};


class OwningSanitizerConfigOrSanitizerPresets : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eSanitizerConfig,
    eSanitizerPresets
  };
public:
  enum class Type
  {
    eSanitizerConfig = TypeOrUninit::eSanitizerConfig,
    eSanitizerPresets = TypeOrUninit::eSanitizerPresets
  };

private:
  union Value
  {
    UnionMember<SanitizerConfig > mSanitizerConfig;
    UnionMember<SanitizerPresets > mSanitizerPresets;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningSanitizerConfigOrSanitizerPresets()
    : mType(eUninitialized)
  {
  }

  OwningSanitizerConfigOrSanitizerPresets(OwningSanitizerConfigOrSanitizerPresets&& aOther);

  explicit inline OwningSanitizerConfigOrSanitizerPresets(const OwningSanitizerConfigOrSanitizerPresets& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningSanitizerConfigOrSanitizerPresets()
  {
    Uninit();
  }

  [[nodiscard]] SanitizerConfig&
  RawSetAsSanitizerConfig();

  [[nodiscard]] SanitizerConfig&
  SetAsSanitizerConfig();

  inline bool
  IsSanitizerConfig() const
  {
    return mType == eSanitizerConfig;
  }

  inline SanitizerConfig&
  GetAsSanitizerConfig()
  {
    MOZ_RELEASE_ASSERT(IsSanitizerConfig(), "Wrong type!");
    return mValue.mSanitizerConfig.Value();
  }

  inline SanitizerConfig const &
  GetAsSanitizerConfig() const
  {
    MOZ_RELEASE_ASSERT(IsSanitizerConfig(), "Wrong type!");
    return mValue.mSanitizerConfig.Value();
  }

  [[nodiscard]] SanitizerPresets&
  RawSetAsSanitizerPresets();

  [[nodiscard]] SanitizerPresets&
  SetAsSanitizerPresets();

  inline bool
  IsSanitizerPresets() const
  {
    return mType == eSanitizerPresets;
  }

  inline SanitizerPresets&
  GetAsSanitizerPresets()
  {
    MOZ_RELEASE_ASSERT(IsSanitizerPresets(), "Wrong type!");
    return mValue.mSanitizerPresets.Value();
  }

  inline SanitizerPresets const &
  GetAsSanitizerPresets() const
  {
    MOZ_RELEASE_ASSERT(IsSanitizerPresets(), "Wrong type!");
    return mValue.mSanitizerPresets.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningSanitizerConfigOrSanitizerPresets&
  operator=(OwningSanitizerConfigOrSanitizerPresets&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningSanitizerConfigOrSanitizerPresets&
  operator=(const OwningSanitizerConfigOrSanitizerPresets& aOther);

private:
  bool
  TrySetToSanitizerConfig(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSanitizerConfig(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroySanitizerConfig();

  bool
  TrySetToSanitizerPresets(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSanitizerPresets(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroySanitizerPresets();
};


class SanitizerOrSanitizerConfigOrSanitizerPresets : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eSanitizer,
    eSanitizerConfig,
    eSanitizerPresets
  };
public:
  enum class Type
  {
    eSanitizer = TypeOrUninit::eSanitizer,
    eSanitizerConfig = TypeOrUninit::eSanitizerConfig,
    eSanitizerPresets = TypeOrUninit::eSanitizerPresets
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::Sanitizer> > mSanitizer;
    UnionMember<binding_detail::FastSanitizerConfig > mSanitizerConfig;
    UnionMember<SanitizerPresets > mSanitizerPresets;

  };

  TypeOrUninit mType;
  Value mValue;

  SanitizerOrSanitizerConfigOrSanitizerPresets(const SanitizerOrSanitizerConfigOrSanitizerPresets&) = delete;
  SanitizerOrSanitizerConfigOrSanitizerPresets& operator=(const SanitizerOrSanitizerConfigOrSanitizerPresets&) = delete;
public:
  explicit inline SanitizerOrSanitizerConfigOrSanitizerPresets()
    : mType(eUninitialized)
  {
  }

  inline ~SanitizerOrSanitizerConfigOrSanitizerPresets()
  {
    Uninit();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Sanitizer>&
  RawSetAsSanitizer()
  {
    if (mType == eSanitizer) {
      return mValue.mSanitizer.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eSanitizer;
    return mValue.mSanitizer.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Sanitizer>&
  SetAsSanitizer()
  {
    if (mType == eSanitizer) {
      return mValue.mSanitizer.Value();
    }
    Uninit();
    mType = eSanitizer;
    return mValue.mSanitizer.SetValue();
  }

  inline bool
  IsSanitizer() const
  {
    return mType == eSanitizer;
  }

  inline NonNull<mozilla::dom::Sanitizer>&
  GetAsSanitizer()
  {
    MOZ_RELEASE_ASSERT(IsSanitizer(), "Wrong type!");
    return mValue.mSanitizer.Value();
  }

  inline mozilla::dom::Sanitizer&
  GetAsSanitizer() const
  {
    MOZ_RELEASE_ASSERT(IsSanitizer(), "Wrong type!");
    return mValue.mSanitizer.Value();
  }

  [[nodiscard]] inline binding_detail::FastSanitizerConfig&
  RawSetAsSanitizerConfig()
  {
    if (mType == eSanitizerConfig) {
      return mValue.mSanitizerConfig.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eSanitizerConfig;
    return mValue.mSanitizerConfig.SetValue();
  }

  [[nodiscard]] inline binding_detail::FastSanitizerConfig&
  SetAsSanitizerConfig()
  {
    if (mType == eSanitizerConfig) {
      return mValue.mSanitizerConfig.Value();
    }
    Uninit();
    mType = eSanitizerConfig;
    return mValue.mSanitizerConfig.SetValue();
  }

  inline bool
  IsSanitizerConfig() const
  {
    return mType == eSanitizerConfig;
  }

  inline binding_detail::FastSanitizerConfig&
  GetAsSanitizerConfig()
  {
    MOZ_RELEASE_ASSERT(IsSanitizerConfig(), "Wrong type!");
    return mValue.mSanitizerConfig.Value();
  }

  inline const SanitizerConfig&
  GetAsSanitizerConfig() const
  {
    MOZ_RELEASE_ASSERT(IsSanitizerConfig(), "Wrong type!");
    return mValue.mSanitizerConfig.Value();
  }

  [[nodiscard]] inline SanitizerPresets&
  RawSetAsSanitizerPresets()
  {
    if (mType == eSanitizerPresets) {
      return mValue.mSanitizerPresets.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eSanitizerPresets;
    return mValue.mSanitizerPresets.SetValue();
  }

  [[nodiscard]] inline SanitizerPresets&
  SetAsSanitizerPresets()
  {
    if (mType == eSanitizerPresets) {
      return mValue.mSanitizerPresets.Value();
    }
    Uninit();
    mType = eSanitizerPresets;
    return mValue.mSanitizerPresets.SetValue();
  }

  inline bool
  IsSanitizerPresets() const
  {
    return mType == eSanitizerPresets;
  }

  inline SanitizerPresets&
  GetAsSanitizerPresets()
  {
    MOZ_RELEASE_ASSERT(IsSanitizerPresets(), "Wrong type!");
    return mValue.mSanitizerPresets.Value();
  }

  inline SanitizerPresets
  GetAsSanitizerPresets() const
  {
    MOZ_RELEASE_ASSERT(IsSanitizerPresets(), "Wrong type!");
    return mValue.mSanitizerPresets.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eSanitizer: {
        DestroySanitizer();
        break;
      }
      case eSanitizerConfig: {
        DestroySanitizerConfig();
        break;
      }
      case eSanitizerPresets: {
        DestroySanitizerPresets();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToSanitizer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSanitizer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroySanitizer()
  {
    MOZ_RELEASE_ASSERT(IsSanitizer(), "Wrong type!");
    mValue.mSanitizer.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToSanitizerConfig(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSanitizerConfig(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroySanitizerConfig()
  {
    MOZ_RELEASE_ASSERT(IsSanitizerConfig(), "Wrong type!");
    mValue.mSanitizerConfig.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToSanitizerPresets(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSanitizerPresets(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroySanitizerPresets()
  {
    MOZ_RELEASE_ASSERT(IsSanitizerPresets(), "Wrong type!");
    mValue.mSanitizerPresets.Destroy();
    mType = eUninitialized;
  }
};


class OwningSanitizerOrSanitizerConfigOrSanitizerPresets : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningSanitizerOrSanitizerConfigOrSanitizerPresets& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eSanitizer,
    eSanitizerConfig,
    eSanitizerPresets
  };
public:
  enum class Type
  {
    eSanitizer = TypeOrUninit::eSanitizer,
    eSanitizerConfig = TypeOrUninit::eSanitizerConfig,
    eSanitizerPresets = TypeOrUninit::eSanitizerPresets
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::Sanitizer> > mSanitizer;
    UnionMember<SanitizerConfig > mSanitizerConfig;
    UnionMember<SanitizerPresets > mSanitizerPresets;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningSanitizerOrSanitizerConfigOrSanitizerPresets()
    : mType(eUninitialized)
  {
  }

  OwningSanitizerOrSanitizerConfigOrSanitizerPresets(OwningSanitizerOrSanitizerConfigOrSanitizerPresets&& aOther);

  explicit inline OwningSanitizerOrSanitizerConfigOrSanitizerPresets(const OwningSanitizerOrSanitizerConfigOrSanitizerPresets& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningSanitizerOrSanitizerConfigOrSanitizerPresets()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::Sanitizer>&
  RawSetAsSanitizer();

  [[nodiscard]] OwningNonNull<mozilla::dom::Sanitizer>&
  SetAsSanitizer();

  inline bool
  IsSanitizer() const
  {
    return mType == eSanitizer;
  }

  inline OwningNonNull<mozilla::dom::Sanitizer>&
  GetAsSanitizer()
  {
    MOZ_RELEASE_ASSERT(IsSanitizer(), "Wrong type!");
    return mValue.mSanitizer.Value();
  }

  inline OwningNonNull<mozilla::dom::Sanitizer> const &
  GetAsSanitizer() const
  {
    MOZ_RELEASE_ASSERT(IsSanitizer(), "Wrong type!");
    return mValue.mSanitizer.Value();
  }

  [[nodiscard]] SanitizerConfig&
  RawSetAsSanitizerConfig();

  [[nodiscard]] SanitizerConfig&
  SetAsSanitizerConfig();

  inline bool
  IsSanitizerConfig() const
  {
    return mType == eSanitizerConfig;
  }

  inline SanitizerConfig&
  GetAsSanitizerConfig()
  {
    MOZ_RELEASE_ASSERT(IsSanitizerConfig(), "Wrong type!");
    return mValue.mSanitizerConfig.Value();
  }

  inline SanitizerConfig const &
  GetAsSanitizerConfig() const
  {
    MOZ_RELEASE_ASSERT(IsSanitizerConfig(), "Wrong type!");
    return mValue.mSanitizerConfig.Value();
  }

  [[nodiscard]] SanitizerPresets&
  RawSetAsSanitizerPresets();

  [[nodiscard]] SanitizerPresets&
  SetAsSanitizerPresets();

  inline bool
  IsSanitizerPresets() const
  {
    return mType == eSanitizerPresets;
  }

  inline SanitizerPresets&
  GetAsSanitizerPresets()
  {
    MOZ_RELEASE_ASSERT(IsSanitizerPresets(), "Wrong type!");
    return mValue.mSanitizerPresets.Value();
  }

  inline SanitizerPresets const &
  GetAsSanitizerPresets() const
  {
    MOZ_RELEASE_ASSERT(IsSanitizerPresets(), "Wrong type!");
    return mValue.mSanitizerPresets.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningSanitizerOrSanitizerConfigOrSanitizerPresets&
  operator=(OwningSanitizerOrSanitizerConfigOrSanitizerPresets&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningSanitizerOrSanitizerConfigOrSanitizerPresets&
  operator=(const OwningSanitizerOrSanitizerConfigOrSanitizerPresets& aOther);

private:
  bool
  TrySetToSanitizer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSanitizer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroySanitizer();

  bool
  TrySetToSanitizerConfig(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSanitizerConfig(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroySanitizerConfig();

  bool
  TrySetToSanitizerPresets(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToSanitizerPresets(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroySanitizerPresets();
};


struct SetHTMLOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR OwningSanitizerOrSanitizerConfigOrSanitizerPresets mSanitizer;

  SetHTMLOptions();

  explicit inline SetHTMLOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  SetHTMLOptions(SetHTMLOptions&& aOther) = default;

  explicit inline SetHTMLOptions(const SetHTMLOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mSanitizer, "mSanitizer", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mSanitizer);
  }

  SetHTMLOptions&
  operator=(const SetHTMLOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, SetHTMLOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastSetHTMLOptions : public SetHTMLOptions
{
  inline FastSetHTMLOptions()
    : SetHTMLOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct SetHTMLUnsafeOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningSanitizerOrSanitizerConfigOrSanitizerPresets> mSanitizer;

  SetHTMLUnsafeOptions();

  explicit inline SetHTMLUnsafeOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  SetHTMLUnsafeOptions(SetHTMLUnsafeOptions&& aOther) = default;

  explicit inline SetHTMLUnsafeOptions(const SetHTMLUnsafeOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mSanitizer, "mSanitizer", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mSanitizer);
  }

  SetHTMLUnsafeOptions&
  operator=(const SetHTMLUnsafeOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, SetHTMLUnsafeOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastSetHTMLUnsafeOptions : public SetHTMLUnsafeOptions
{
  inline FastSetHTMLUnsafeOptions()
    : SetHTMLUnsafeOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace Sanitizer_Binding {

  typedef mozilla::dom::Sanitizer NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::Sanitizer* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::Sanitizer,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace Sanitizer_Binding



} // namespace dom


template <>
struct MaxContiguousEnumValue<dom::SanitizerPresets>
{
  static constexpr dom::SanitizerPresets value = dom::SanitizerPresets::Default;

  static_assert(static_cast<uint8_t>(dom::SanitizerPresets::Default) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::SanitizerPresets>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};


} // namespace mozilla

#endif // DOM_SANITIZERBINDING_H_
