/* THIS FILE IS AUTOGENERATED FROM CSSStyleSheet.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_CSSStyleSheetBinding_h
#define mozilla_dom_CSSStyleSheetBinding_h

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {

class StyleSheet;

namespace dom {

struct CSSStyleSheetInitAtoms;
class MediaList;
class MediaListOrUTF8String;
struct NativePropertyHooks;
class OwningMediaListOrUTF8String;
class ProtoAndIfaceCache;

} // namespace dom

} // namespace mozilla

namespace mozilla::dom {

enum class CSSStyleSheetParsingMode : uint8_t {
  Author,
  User,
  Agent,
  EndGuard_
};

namespace CSSStyleSheetParsingModeValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(CSSStyleSheetParsingMode::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(CSSStyleSheetParsingMode stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace CSSStyleSheetParsingModeValues

bool
ToJSValue(JSContext* aCx, CSSStyleSheetParsingMode aArgument, JS::MutableHandle<JS::Value> aValue);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningMediaListOrUTF8String& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningMediaListOrUTF8String& aUnion);


class MediaListOrUTF8String
{
  enum TypeOrUninit
  {
    eUninitialized,
    eMediaList,
    eUTF8String
  };
public:
  enum class Type
  {
    eMediaList = TypeOrUninit::eMediaList,
    eUTF8String = TypeOrUninit::eUTF8String
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::MediaList> > mMediaList;
    UnionMember<binding_detail::FakeString<char> > mUTF8String;

  };

  TypeOrUninit mType;
  Value mValue;

  MediaListOrUTF8String(const MediaListOrUTF8String&) = delete;
  MediaListOrUTF8String& operator=(const MediaListOrUTF8String&) = delete;
public:
  explicit inline MediaListOrUTF8String()
    : mType(eUninitialized)
  {
  }

  inline ~MediaListOrUTF8String()
  {
    Uninit();
  }

  inline NonNull<mozilla::dom::MediaList>&
  RawSetAsMediaList()
  {
    if (mType == eMediaList) {
      return mValue.mMediaList.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eMediaList;
    return mValue.mMediaList.SetValue();
  }

  inline NonNull<mozilla::dom::MediaList>&
  SetAsMediaList()
  {
    if (mType == eMediaList) {
      return mValue.mMediaList.Value();
    }
    Uninit();
    mType = eMediaList;
    return mValue.mMediaList.SetValue();
  }

  inline bool
  IsMediaList() const
  {
    return mType == eMediaList;
  }

  inline NonNull<mozilla::dom::MediaList>&
  GetAsMediaList()
  {
    MOZ_RELEASE_ASSERT(IsMediaList(), "Wrong type!");
    return mValue.mMediaList.Value();
  }

  inline mozilla::dom::MediaList&
  GetAsMediaList() const
  {
    MOZ_RELEASE_ASSERT(IsMediaList(), "Wrong type!");
    return mValue.mMediaList.Value();
  }

  inline binding_detail::FakeString<char>&
  RawSetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  inline binding_detail::FakeString<char>&
  SetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    Uninit();
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline binding_detail::FakeString<char>&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline const nsACString&
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eMediaList: {
        DestroyMediaList();
        break;
      }
      case eUTF8String: {
        DestroyUTF8String();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToMediaList(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToMediaList(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyMediaList()
  {
    MOZ_RELEASE_ASSERT(IsMediaList(), "Wrong type!");
    mValue.mMediaList.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    mValue.mUTF8String.Destroy();
    mType = eUninitialized;
  }
};


class OwningMediaListOrUTF8String : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningMediaListOrUTF8String& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eMediaList,
    eUTF8String
  };
public:
  enum class Type
  {
    eMediaList = TypeOrUninit::eMediaList,
    eUTF8String = TypeOrUninit::eUTF8String
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::MediaList> > mMediaList;
    UnionMember<nsCString > mUTF8String;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningMediaListOrUTF8String()
    : mType(eUninitialized)
  {
  }

  OwningMediaListOrUTF8String(OwningMediaListOrUTF8String&& aOther);

  explicit inline OwningMediaListOrUTF8String(const OwningMediaListOrUTF8String& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningMediaListOrUTF8String()
  {
    Uninit();
  }

  OwningNonNull<mozilla::dom::MediaList>&
  RawSetAsMediaList();

  OwningNonNull<mozilla::dom::MediaList>&
  SetAsMediaList();

  inline bool
  IsMediaList() const
  {
    return mType == eMediaList;
  }

  inline OwningNonNull<mozilla::dom::MediaList>&
  GetAsMediaList()
  {
    MOZ_RELEASE_ASSERT(IsMediaList(), "Wrong type!");
    return mValue.mMediaList.Value();
  }

  inline OwningNonNull<mozilla::dom::MediaList> const &
  GetAsMediaList() const
  {
    MOZ_RELEASE_ASSERT(IsMediaList(), "Wrong type!");
    return mValue.mMediaList.Value();
  }

  nsCString&
  RawSetAsUTF8String();

  nsCString&
  SetAsUTF8String();

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline nsCString&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline nsCString const &
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningMediaListOrUTF8String&
  operator=(OwningMediaListOrUTF8String&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningMediaListOrUTF8String&
  operator=(const OwningMediaListOrUTF8String& aOther);

private:
  bool
  TrySetToMediaList(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToMediaList(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyMediaList();

  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUTF8String();
};


struct CSSStyleSheetInit : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsCString> mBaseURL;
  MOZ_INIT_OUTSIDE_CTOR bool mDisabled;
  MOZ_INIT_OUTSIDE_CTOR OwningMediaListOrUTF8String mMedia;

  CSSStyleSheetInit();

  explicit inline CSSStyleSheetInit(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  CSSStyleSheetInit(CSSStyleSheetInit&& aOther) = default;

  explicit inline CSSStyleSheetInit(const CSSStyleSheetInit& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mMedia, "mMedia", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mMedia);
  }

  CSSStyleSheetInit&
  operator=(const CSSStyleSheetInit& aOther);

private:
  static bool
  InitIds(JSContext* cx, CSSStyleSheetInitAtoms* atomsCache);
};

namespace binding_detail {
struct FastCSSStyleSheetInit : public CSSStyleSheetInit
{
  inline FastCSSStyleSheetInit()
    : CSSStyleSheetInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace CSSStyleSheet_Binding {

  typedef mozilla::StyleSheet NativeType;

  bool
  Wrap(JSContext* aCx, mozilla::StyleSheet* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::CSSStyleSheet,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::CSSStyleSheet,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::CSSStyleSheet,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace CSSStyleSheet_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_CSSStyleSheetBinding_h
