/* THIS FILE IS AUTOGENERATED FROM CheckerboardReportService.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_CheckerboardReportServiceBinding_h
#define mozilla_dom_CheckerboardReportServiceBinding_h

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"

namespace mozilla {
namespace dom {

struct CheckerboardReportAtoms;
class CheckerboardReportService;
struct NativePropertyHooks;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

enum class CheckerboardReason : uint8_t {
  Severe,
  Recent,
  EndGuard_
};

namespace CheckerboardReasonValues {
extern const EnumEntry strings[3];

static constexpr size_t Count = 2;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(CheckerboardReason::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(CheckerboardReason stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace CheckerboardReasonValues

bool
ToJSValue(JSContext* aCx, CheckerboardReason aArgument, JS::MutableHandle<JS::Value> aValue);


struct CheckerboardReport : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mLog;
  MOZ_INIT_OUTSIDE_CTOR Optional<CheckerboardReason> mReason;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mSeverity;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint64_t> mTimestamp;

  CheckerboardReport();

  explicit inline CheckerboardReport(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  CheckerboardReport(CheckerboardReport&& aOther) = default;

  explicit inline CheckerboardReport(const CheckerboardReport& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  CheckerboardReport&
  operator=(const CheckerboardReport& aOther);

private:
  static bool
  InitIds(JSContext* cx, CheckerboardReportAtoms* atomsCache);
};

namespace binding_detail {
struct FastCheckerboardReport : public CheckerboardReport
{
  inline FastCheckerboardReport()
    : CheckerboardReport(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace CheckerboardReportService_Binding {

  typedef mozilla::dom::CheckerboardReportService NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::CheckerboardReportService* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::CheckerboardReportService,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::CheckerboardReportService,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::CheckerboardReportService,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace CheckerboardReportService_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_CheckerboardReportServiceBinding_h
