// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanTelemetryMetrics_h
#define mozilla_GleanTelemetryMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace browser_engagement {
  /**
   * generated from browser.engagement.session_time_excluding_suspend
   * The duration of the session in milliseconds, excluding the time the device was suspended. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.session_time_excluding_suspend.
   */
  constexpr impl::QuantityMetric session_time_excluding_suspend(38);

  /**
   * generated from browser.engagement.session_time_including_suspend
   * The duration of the session in milliseconds, including the time the device was suspended. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.session_time_including_suspend.
   */
  constexpr impl::QuantityMetric session_time_including_suspend(39);
}

namespace browser_timings {
  /**
   * generated from browser.timings.last_shutdown
   * The time, in milliseconds, it took to complete the last shutdown. On successful shutdown, Telemetry saves this to disk into Telemetry.ShutdownTime.txt. On the next startup this is loaded and recorded. This metric was generated to correspond to the Legacy Telemetry scalar browser.timings.last_shutdown.
   */
  constexpr impl::QuantityMetric last_shutdown(45);
}

namespace legacy_telemetry {
  /**
   * generated from legacy.telemetry.client_id
   * The client_id according to Telemetry.
   * Might not always have a value due to being too early for it to have
   * loaded.
   * Value may be the canary client id `c0ffeec0-ffee-c0ff-eec0-ffeec0ffeec0`
   * in pings near when the data upload pref is disabled (if Telemetry gets
   * to go first), or between when a client_id has been removed and when it
   * has been regenerated.
   * Does not need to be sent in the Glean "deletion-request" ping.
   */
  constexpr impl::UuidMetric client_id(5542);

  /**
   * generated from legacy.telemetry.profile_group_id
   * The profile_group_id according to Telemetry.
   * Might not always have a value due to being too early for it to have
   * loaded.
   * Does not need to be sent in the Glean "deletion-request" ping.
   */
  constexpr impl::UuidMetric profile_group_id(5543);
}

namespace onboarding_opt_out {


}

namespace telemetry {
  /**
   * generated from telemetry.archive_checking_over_quota
   * Time (ms) it takes for checking if the archive is over-quota
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TELEMETRY_ARCHIVE_CHECKING_OVER_QUOTA_MS.
   */
  constexpr impl::TimingDistributionMetric archive_checking_over_quota(5547);

  /**
   * generated from telemetry.archive_directories_count
   * Number of directories in the archive at scan
   * This metric was generated to correspond to the Legacy Telemetry linear histogram TELEMETRY_ARCHIVE_DIRECTORIES_COUNT.
   */
  constexpr impl::CustomDistributionMetric archive_directories_count(5548);

  /**
   * generated from telemetry.archive_evicted_old_dirs
   * Number of Telemetry directories evicted from the archive during cleanup, because they were too old
   * This metric was generated to correspond to the Legacy Telemetry linear histogram TELEMETRY_ARCHIVE_EVICTED_OLD_DIRS.
   */
  constexpr impl::CustomDistributionMetric archive_evicted_old_dirs(5549);

  /**
   * generated from telemetry.archive_evicted_over_quota
   * Number of Telemetry pings evicted from the archive during cleanup, because they were over the quota
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TELEMETRY_ARCHIVE_EVICTED_OVER_QUOTA.
   */
  constexpr impl::CustomDistributionMetric archive_evicted_over_quota(5550);

  /**
   * generated from telemetry.archive_evicting_dirs
   * Time (ms) it takes for evicting old directories
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TELEMETRY_ARCHIVE_EVICTING_DIRS_MS.
   */
  constexpr impl::TimingDistributionMetric archive_evicting_dirs(5551);

  /**
   * generated from telemetry.archive_evicting_over_quota
   * Time (ms) it takes for evicting over-quota pings
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TELEMETRY_ARCHIVE_EVICTING_OVER_QUOTA_MS.
   */
  constexpr impl::TimingDistributionMetric archive_evicting_over_quota(5552);

  /**
   * generated from telemetry.archive_oldest_directory_age
   * The age of the oldest Telemetry archive directory in months
   * This metric was generated to correspond to the Legacy Telemetry linear histogram TELEMETRY_ARCHIVE_OLDEST_DIRECTORY_AGE.
   */
  constexpr impl::CustomDistributionMetric archive_oldest_directory_age(5553);

  /**
   * generated from telemetry.archive_scan_ping_count
   * Number of Telemetry pings in the archive at scan
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TELEMETRY_ARCHIVE_SCAN_PING_COUNT.
   */
  constexpr impl::CustomDistributionMetric archive_scan_ping_count(5554);

  /**
   * generated from telemetry.archive_session_ping_count
   * Number of Telemetry pings added to the archive during the session
   * This metric was generated to correspond to the Legacy Telemetry count histogram TELEMETRY_ARCHIVE_SESSION_PING_COUNT.
   */
  constexpr impl::CounterMetric archive_session_ping_count(5555);

  /**
   * generated from telemetry.archive_size
   * The size of the Telemetry archive (MB)
   * This metric was generated to correspond to the Legacy Telemetry linear histogram TELEMETRY_ARCHIVE_SIZE_MB.
   */
  constexpr impl::MemoryDistributionMetric archive_size(5556);

  /**
   * generated from telemetry.compress
   * Time taken to compress telemetry object (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TELEMETRY_COMPRESS.
   */
  constexpr impl::TimingDistributionMetric compress(5557);

  /**
   * generated from telemetry.data_upload_optin
   * User opted into sending Telemetry data again. This metric was generated to correspond to the Legacy Telemetry scalar telemetry.data_upload_optin.
   */
  constexpr impl::BooleanMetric data_upload_optin(5558);

  /**
   * generated from telemetry.discarded_archived_pings_size
   * The size (MB) of the Telemetry archived, compressed, pings exceeding the maximum file size
   * This metric was generated to correspond to the Legacy Telemetry linear histogram TELEMETRY_DISCARDED_ARCHIVED_PINGS_SIZE_MB.
   */
  constexpr impl::MemoryDistributionMetric discarded_archived_pings_size(5559);

  /**
   * generated from telemetry.discarded_pending_pings_size
   * The size (MB) of the Telemetry pending pings exceeding the maximum file size
   * This metric was generated to correspond to the Legacy Telemetry linear histogram TELEMETRY_DISCARDED_PENDING_PINGS_SIZE_MB.
   */
  constexpr impl::MemoryDistributionMetric discarded_pending_pings_size(5560);

  /**
   * generated from telemetry.discarded_send_pings_size
   * The size (MB) of the ping data submitted to Telemetry exceeding the maximum size
   * This metric was generated to correspond to the Legacy Telemetry linear histogram TELEMETRY_DISCARDED_SEND_PINGS_SIZE_MB.
   */
  constexpr impl::MemoryDistributionMetric discarded_send_pings_size(5561);

  /**
   * generated from telemetry.event_ping_sent
   */
  enum class EventPingSentLabel: uint16_t {
    ePeriodic = 0,
    eMax = 1,
    eShutdown = 2,
    e__Other__,
  };
  /**
   * Number of 'event' pings sent, by reason
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram TELEMETRY_EVENT_PING_SENT.
   */
  constexpr impl::Labeled<impl::CounterMetric, EventPingSentLabel> event_ping_sent(5562);

  /**
   * generated from telemetry.event_recording_error
   */
  enum class EventRecordingErrorLabel: uint16_t {
    eUnknownevent = 0,
    eExpired = 1,
    eExtrakey = 2,
    eValue = 3,
    eExtra = 4,
    e__Other__,
  };
  /**
   * Number of event recording failures, by type of failure
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram TELEMETRY_EVENT_RECORDING_ERROR.
   */
  constexpr impl::Labeled<impl::CounterMetric, EventRecordingErrorLabel> event_recording_error(5563);

  /**
   * generated from telemetry.event_registration_error
   */
  enum class EventRegistrationErrorLabel: uint16_t {
    eOther = 0,
    eName = 1,
    eCategory = 2,
    eMethod = 3,
    eObject = 4,
    eExtrakeys = 5,
    e__Other__,
  };
  /**
   * Number of event registration failures, by field causing the failure
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram TELEMETRY_EVENT_REGISTRATION_ERROR.
   */
  constexpr impl::Labeled<impl::CounterMetric, EventRegistrationErrorLabel> event_registration_error(5564);

  /**
   * generated from telemetry.invalid_payload_submitted
   * Count of individual invalid payloads that were submitted to Telemetry.
   * This metric was generated to correspond to the Legacy Telemetry count histogram TELEMETRY_INVALID_PAYLOAD_SUBMITTED.
   */
  constexpr impl::CounterMetric invalid_payload_submitted(5565);

  /**
   * generated from telemetry.invalid_ping_type_submitted
   * Count of individual invalid ping types that were submitted to Telemetry.
   * This metric was generated to correspond to the Legacy Telemetry count histogram TELEMETRY_INVALID_PING_TYPE_SUBMITTED.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> invalid_ping_type_submitted(5566);

  /**
   * generated from telemetry.pending_checking_over_quota
   * Time (ms) it takes for checking if the pending pings are over-quota
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TELEMETRY_PENDING_CHECKING_OVER_QUOTA_MS.
   */
  constexpr impl::TimingDistributionMetric pending_checking_over_quota(5567);

  /**
   * generated from telemetry.pending_evicting_over_quota
   * Time (ms) it takes for evicting over-quota pending pings
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TELEMETRY_PENDING_EVICTING_OVER_QUOTA_MS.
   */
  constexpr impl::TimingDistributionMetric pending_evicting_over_quota(5568);

  /**
   * generated from telemetry.pending_load_failure_parse
   * Number of pending Telemetry pings that failed to parse once loaded from the disk
   * This metric was generated to correspond to the Legacy Telemetry count histogram TELEMETRY_PENDING_LOAD_FAILURE_PARSE.
   */
  constexpr impl::CounterMetric pending_load_failure_parse(5569);

  /**
   * generated from telemetry.pending_load_failure_read
   * Number of pending Telemetry pings that failed to load from the disk
   * This metric was generated to correspond to the Legacy Telemetry count histogram TELEMETRY_PENDING_LOAD_FAILURE_READ.
   */
  constexpr impl::CounterMetric pending_load_failure_read(5570);

  /**
   * generated from telemetry.pending_pings_age
   * The age, in days, of the pending pings.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TELEMETRY_PENDING_PINGS_AGE.
   */
  constexpr impl::TimingDistributionMetric pending_pings_age(5571);

  /**
   * generated from telemetry.pending_pings_evicted_over_quota
   * Number of Telemetry pings evicted from the pending pings directory during cleanup, because they were over the quota
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TELEMETRY_PENDING_PINGS_EVICTED_OVER_QUOTA.
   */
  constexpr impl::CustomDistributionMetric pending_pings_evicted_over_quota(5572);

  /**
   * generated from telemetry.pending_pings_size
   * The size of the Telemetry pending pings directory (MB). The special value 17 is used to indicate over quota pings.
   * This metric was generated to correspond to the Legacy Telemetry linear histogram TELEMETRY_PENDING_PINGS_SIZE_MB.
   */
  constexpr impl::MemoryDistributionMetric pending_pings_size(5573);

  /**
   * generated from telemetry.ping_evicted_for_server_errors
   * Number of Telemetry ping files evicted due to server errors (4XX HTTP code received)
   * This metric was generated to correspond to the Legacy Telemetry count histogram TELEMETRY_PING_EVICTED_FOR_SERVER_ERRORS.
   */
  constexpr impl::CounterMetric ping_evicted_for_server_errors(5574);

  /**
   * generated from telemetry.ping_size_exceeded_archived
   * Number of archived Telemetry pings discarded because they exceeded the maximum size
   * This metric was generated to correspond to the Legacy Telemetry count histogram TELEMETRY_PING_SIZE_EXCEEDED_ARCHIVED.
   */
  constexpr impl::CounterMetric ping_size_exceeded_archived(5575);

  /**
   * generated from telemetry.ping_size_exceeded_pending
   * Number of Telemetry pending pings discarded because they exceeded the maximum size
   * This metric was generated to correspond to the Legacy Telemetry count histogram TELEMETRY_PING_SIZE_EXCEEDED_PENDING.
   */
  constexpr impl::CounterMetric ping_size_exceeded_pending(5576);

  /**
   * generated from telemetry.ping_size_exceeded_send
   * Number of Telemetry pings discarded before sending because they exceeded the maximum size
   * This metric was generated to correspond to the Legacy Telemetry count histogram TELEMETRY_PING_SIZE_EXCEEDED_SEND.
   */
  constexpr impl::CounterMetric ping_size_exceeded_send(5577);

  /**
   * generated from telemetry.ping_submission_waiting_clientid
   * The number of pings that were submitted and had to wait for a client id (i.e. before it was cached or loaded from disk)
   * This metric was generated to correspond to the Legacy Telemetry count histogram TELEMETRY_PING_SUBMISSION_WAITING_CLIENTID.
   */
  constexpr impl::CounterMetric ping_submission_waiting_clientid(5578);

  /**
   * generated from telemetry.send_failure
   * Time needed (in ms) for a failed send of a Telemetry ping to the servers and getting a reply back.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TELEMETRY_SEND_FAILURE.
   */
  constexpr impl::TimingDistributionMetric send_failure(5579);

  /**
   * generated from telemetry.send_failure_type
   */
  enum class SendFailureTypeLabel: uint16_t {
    eEok = 0,
    eErequest = 1,
    eEunreachable = 2,
    eEchannelopen = 3,
    eEredirect = 4,
    eAbort = 5,
    eTimeout = 6,
    eEtoolate = 7,
    eEterminated = 8,
    e__Other__,
  };
  /**
   * Counts of the different ways sending a Telemetry ping can fail.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram TELEMETRY_SEND_FAILURE_TYPE.
   */
  constexpr impl::Labeled<impl::CounterMetric, SendFailureTypeLabel> send_failure_type(5580);

  /**
   * generated from telemetry.send_success
   * Time needed (in ms) for a successful send of a Telemetry ping to the servers and getting a reply back.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TELEMETRY_SEND_SUCCESS.
   */
  constexpr impl::TimingDistributionMetric send_success(5581);

  /**
   * generated from telemetry.stringify
   * Time to stringify telemetry object (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TELEMETRY_STRINGIFY.
   */
  constexpr impl::TimingDistributionMetric stringify(5582);

  /**
   * generated from telemetry.success
   */
  enum class SuccessLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Successful telemetry submission
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram TELEMETRY_SUCCESS.
   */
  constexpr impl::Labeled<impl::CounterMetric, SuccessLabel> success(5583);
}

namespace usage {
  /**
   * generated from usage.app_build
   * The build identifier generated by the CI system (e.g. "1234/A").
   * If the value was not provided through configuration,
   * this metric gets set to `Unknown`.
   */
  constexpr impl::StringMetric app_build(5584);

  /**
   * generated from usage.app_channel
   * The channel the application is being distributed on.
   */
  constexpr impl::StringMetric app_channel(5585);

  /**
   * generated from usage.app_display_version
   * The user visible version string (e.g. "1.0.3").
   * If the value was not provided through configuration,
   * this metric gets set to `Unknown`.
   */
  constexpr impl::StringMetric app_display_version(5586);

  /**
   * generated from usage.distribution_id
   * The distribution id associated with the install of Firefox.
   */
  constexpr impl::StringMetric distribution_id(5587);

  /**
   * generated from usage.first_run_date
   * The date of the profile's first use. Set from `ProfileAge.firstUse`
   */
  constexpr impl::DatetimeMetric first_run_date(5588);

  /**
   * generated from usage.is_default_browser
   * Whether Firefox is set as the default browser.
   */
  constexpr impl::BooleanMetric is_default_browser(5589);

  /**
   * generated from usage.os
   * The name of the operating system.
   * Possible values:
   * Android, iOS, Linux, Darwin, Windows,
   * FreeBSD, NetBSD, OpenBSD, Solaris, Unknown
   */
  constexpr impl::StringMetric os(5590);

  /**
   * generated from usage.os_version
   * The user-visible version of the operating system (e.g. "1.2.3").
   * If the version detection fails, this metric gets set to `Unknown`.
   */
  constexpr impl::StringMetric os_version(5591);

  /**
   * generated from usage.profile_group_id
   * A UUID uniquely identifying the profile group,
   * not shared with other telemetry data.
   */
  constexpr impl::UuidMetric profile_group_id(5592);

  /**
   * generated from usage.profile_id
   * A UUID uniquely identifying the profile,
   * not shared with other telemetry data.
   */
  constexpr impl::UuidMetric profile_id(5593);

  /**
   * generated from usage.reason
   * The reason the usage-reporting ping was sent.
   */
  constexpr impl::StringMetric reason(5594);

  /**
   * generated from usage.windows_build_number
   * The optional Windows build number, reported by Windows
   * (e.g. 22000) and not set for other platforms.
   */
  constexpr impl::QuantityMetric windows_build_number(5595);
}

} // namespace mozilla::glean

#endif // mozilla_GleanTelemetryMetrics_h
