/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_dom_SanitizerDefaultConfig_h
#define mozilla_dom_SanitizerDefaultConfig_h

// This file is automatically generated by update-safe-default-configuration.py

#include "mozilla/dom/SanitizerTypes.h"
#include "SanitizerDefaultConfig.h"
#include "nsGkAtoms.h"

namespace mozilla::dom::sanitizer {

constexpr nsStaticAtom* kDefaultHTMLElements[] = {
    // clang-format off
    nsGkAtoms::html,
    nsGkAtoms::head,
    nsGkAtoms::title,
    nsGkAtoms::body,
    nsGkAtoms::article,
    nsGkAtoms::section,
    nsGkAtoms::nav,
    nsGkAtoms::aside,
    nsGkAtoms::h1,
    nsGkAtoms::h2,
    nsGkAtoms::h3,
    nsGkAtoms::h4,
    nsGkAtoms::h5,
    nsGkAtoms::h6,
    nsGkAtoms::hgroup,
    nsGkAtoms::header,
    nsGkAtoms::footer,
    nsGkAtoms::address,
    nsGkAtoms::p,
    nsGkAtoms::hr,
    nsGkAtoms::pre,
    nsGkAtoms::blockquote,
    nsGkAtoms::ol,
    nsGkAtoms::ul,
    nsGkAtoms::menu,
    nsGkAtoms::li,
    nsGkAtoms::dl,
    nsGkAtoms::dt,
    nsGkAtoms::dd,
    nsGkAtoms::figure,
    nsGkAtoms::figcaption,
    nsGkAtoms::main,
    nsGkAtoms::search,
    nsGkAtoms::div,
    nsGkAtoms::a,
    nsGkAtoms::em,
    nsGkAtoms::strong,
    nsGkAtoms::small,
    nsGkAtoms::s,
    nsGkAtoms::cite,
    nsGkAtoms::q,
    nsGkAtoms::dfn,
    nsGkAtoms::abbr,
    nsGkAtoms::ruby,
    nsGkAtoms::rt,
    nsGkAtoms::rp,
    nsGkAtoms::data,
    nsGkAtoms::time,
    nsGkAtoms::code,
    nsGkAtoms::var,
    nsGkAtoms::samp,
    nsGkAtoms::kbd,
    nsGkAtoms::sub,
    nsGkAtoms::sup,
    nsGkAtoms::i,
    nsGkAtoms::b,
    nsGkAtoms::u,
    nsGkAtoms::mark,
    nsGkAtoms::bdi,
    nsGkAtoms::bdo,
    nsGkAtoms::span,
    nsGkAtoms::br,
    nsGkAtoms::wbr,
    nsGkAtoms::ins,
    nsGkAtoms::del,
    nsGkAtoms::table,
    nsGkAtoms::caption,
    nsGkAtoms::colgroup,
    nsGkAtoms::col,
    nsGkAtoms::tbody,
    nsGkAtoms::thead,
    nsGkAtoms::tfoot,
    nsGkAtoms::tr,
    nsGkAtoms::td,
    nsGkAtoms::th,
    // clang-format on
};

constexpr nsStaticAtom* kDefaultMathMLElements[] = {
    // clang-format off
    nsGkAtoms::math,
    nsGkAtoms::merror,
    nsGkAtoms::mfrac,
    nsGkAtoms::mi,
    nsGkAtoms::mmultiscripts,
    nsGkAtoms::mn,
    nsGkAtoms::mo,
    nsGkAtoms::mover,
    nsGkAtoms::mpadded,
    nsGkAtoms::mphantom,
    nsGkAtoms::mprescripts,
    nsGkAtoms::mroot,
    nsGkAtoms::mrow,
    nsGkAtoms::ms,
    nsGkAtoms::mspace,
    nsGkAtoms::msqrt,
    nsGkAtoms::mstyle,
    nsGkAtoms::msub,
    nsGkAtoms::msubsup,
    nsGkAtoms::msup,
    nsGkAtoms::mtable,
    nsGkAtoms::mtd,
    nsGkAtoms::mtext,
    nsGkAtoms::mtr,
    nsGkAtoms::munder,
    nsGkAtoms::munderover,
    nsGkAtoms::semantics,
    // clang-format on
};

constexpr nsStaticAtom* kDefaultAttributes[] = {
    // clang-format off
    nsGkAtoms::dir,
    nsGkAtoms::lang,
    nsGkAtoms::title,
    nsGkAtoms::displaystyle,
    nsGkAtoms::mathbackground,
    nsGkAtoms::mathcolor,
    nsGkAtoms::mathsize,
    nsGkAtoms::scriptlevel,
    // clang-format on
};

// Data is encoded as: element, attributes..., nullptr
constexpr nsStaticAtom* kHTMLElementWithAttributes[] = {
    // clang-format off
    /* element */ nsGkAtoms::blockquote,
    nsGkAtoms::cite,
    nullptr,
    /* element */ nsGkAtoms::ol,
    nsGkAtoms::reversed,
    nsGkAtoms::start,
    nsGkAtoms::type,
    nullptr,
    /* element */ nsGkAtoms::li,
    nsGkAtoms::value,
    nullptr,
    /* element */ nsGkAtoms::a,
    nsGkAtoms::href,
    nsGkAtoms::rel,
    nsGkAtoms::hreflang,
    nsGkAtoms::type,
    nullptr,
    /* element */ nsGkAtoms::data,
    nsGkAtoms::value,
    nullptr,
    /* element */ nsGkAtoms::time,
    nsGkAtoms::datetime,
    nullptr,
    /* element */ nsGkAtoms::ins,
    nsGkAtoms::cite,
    nsGkAtoms::datetime,
    nullptr,
    /* element */ nsGkAtoms::del,
    nsGkAtoms::cite,
    nsGkAtoms::datetime,
    nullptr,
    /* element */ nsGkAtoms::colgroup,
    nsGkAtoms::span,
    nullptr,
    /* element */ nsGkAtoms::col,
    nsGkAtoms::span,
    nullptr,
    /* element */ nsGkAtoms::td,
    nsGkAtoms::colspan,
    nsGkAtoms::rowspan,
    nsGkAtoms::headers,
    nullptr,
    /* element */ nsGkAtoms::th,
    nsGkAtoms::colspan,
    nsGkAtoms::rowspan,
    nsGkAtoms::headers,
    nsGkAtoms::scope,
    nsGkAtoms::abbr,
    nullptr,
    /* sentinel */ nullptr,
    // clang-format on
};

constexpr nsStaticAtom* kMathMLElementWithAttributes[] = {
    // clang-format off
    /* element */ nsGkAtoms::mo,
    nsGkAtoms::form,
    nsGkAtoms::fence,
    nsGkAtoms::separator,
    nsGkAtoms::lspace,
    nsGkAtoms::rspace,
    nsGkAtoms::stretchy,
    nsGkAtoms::symmetric,
    nsGkAtoms::maxsize,
    nsGkAtoms::minsize,
    nsGkAtoms::largeop,
    nsGkAtoms::movablelimits,
    nullptr,
    /* element */ nsGkAtoms::mover,
    nsGkAtoms::accent,
    nullptr,
    /* element */ nsGkAtoms::mpadded,
    nsGkAtoms::width,
    nsGkAtoms::height,
    nsGkAtoms::depth,
    nsGkAtoms::lspace,
    nsGkAtoms::voffset,
    nullptr,
    /* element */ nsGkAtoms::mspace,
    nsGkAtoms::width,
    nsGkAtoms::height,
    nsGkAtoms::depth,
    nullptr,
    /* element */ nsGkAtoms::mtd,
    nsGkAtoms::columnspan,
    nsGkAtoms::rowspan,
    nullptr,
    /* element */ nsGkAtoms::munder,
    nsGkAtoms::accentunder,
    nullptr,
    /* element */ nsGkAtoms::munderover,
    nsGkAtoms::accent,
    nsGkAtoms::accentunder,
    nullptr,
    /* sentinel */ nullptr,
    // clang-format on
};

}  // namespace mozilla::dom::sanitizer

#endif  // mozilla_dom_SanitizerDefaultConfig_h
