/* THIS FILE IS AUTOGENERATED FROM CSSCustomMediaRule.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_CSSCUSTOMMEDIARULEBINDING_H_
#define DOM_CSSCUSTOMMEDIARULEBINDING_H_

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

class CSSCustomMediaRule;
class MediaList;
struct NativePropertyHooks;
class OwningMediaListOrBoolean;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningMediaListOrBoolean& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningMediaListOrBoolean& aUnion);


class MediaListOrBoolean : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eMediaList,
    eBoolean
  };
public:
  enum class Type
  {
    eMediaList = TypeOrUninit::eMediaList,
    eBoolean = TypeOrUninit::eBoolean
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::MediaList> > mMediaList;
    UnionMember<bool > mBoolean;

  };

  TypeOrUninit mType;
  Value mValue;

  MediaListOrBoolean(const MediaListOrBoolean&) = delete;
  MediaListOrBoolean& operator=(const MediaListOrBoolean&) = delete;
public:
  explicit inline MediaListOrBoolean()
    : mType(eUninitialized)
  {
  }

  inline ~MediaListOrBoolean()
  {
    Uninit();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::MediaList>&
  RawSetAsMediaList()
  {
    if (mType == eMediaList) {
      return mValue.mMediaList.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eMediaList;
    return mValue.mMediaList.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::MediaList>&
  SetAsMediaList()
  {
    if (mType == eMediaList) {
      return mValue.mMediaList.Value();
    }
    Uninit();
    mType = eMediaList;
    return mValue.mMediaList.SetValue();
  }

  inline bool
  IsMediaList() const
  {
    return mType == eMediaList;
  }

  inline NonNull<mozilla::dom::MediaList>&
  GetAsMediaList()
  {
    MOZ_RELEASE_ASSERT(IsMediaList(), "Wrong type!");
    return mValue.mMediaList.Value();
  }

  inline mozilla::dom::MediaList&
  GetAsMediaList() const
  {
    MOZ_RELEASE_ASSERT(IsMediaList(), "Wrong type!");
    return mValue.mMediaList.Value();
  }

  [[nodiscard]] inline bool&
  RawSetAsBoolean()
  {
    if (mType == eBoolean) {
      return mValue.mBoolean.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eBoolean;
    return mValue.mBoolean.SetValue();
  }

  [[nodiscard]] inline bool&
  SetAsBoolean()
  {
    if (mType == eBoolean) {
      return mValue.mBoolean.Value();
    }
    Uninit();
    mType = eBoolean;
    return mValue.mBoolean.SetValue();
  }

  inline bool
  IsBoolean() const
  {
    return mType == eBoolean;
  }

  inline bool&
  GetAsBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool
  GetAsBoolean() const
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eMediaList: {
        DestroyMediaList();
        break;
      }
      case eBoolean: {
        DestroyBoolean();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToMediaList(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToMediaList(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyMediaList()
  {
    MOZ_RELEASE_ASSERT(IsMediaList(), "Wrong type!");
    mValue.mMediaList.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    mValue.mBoolean.Destroy();
    mType = eUninitialized;
  }
};


class OwningMediaListOrBoolean : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningMediaListOrBoolean& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eMediaList,
    eBoolean
  };
public:
  enum class Type
  {
    eMediaList = TypeOrUninit::eMediaList,
    eBoolean = TypeOrUninit::eBoolean
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::MediaList> > mMediaList;
    UnionMember<bool > mBoolean;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningMediaListOrBoolean()
    : mType(eUninitialized)
  {
  }

  OwningMediaListOrBoolean(OwningMediaListOrBoolean&& aOther);

  explicit inline OwningMediaListOrBoolean(const OwningMediaListOrBoolean& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningMediaListOrBoolean()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::MediaList>&
  RawSetAsMediaList();

  [[nodiscard]] OwningNonNull<mozilla::dom::MediaList>&
  SetAsMediaList();

  inline bool
  IsMediaList() const
  {
    return mType == eMediaList;
  }

  inline OwningNonNull<mozilla::dom::MediaList>&
  GetAsMediaList()
  {
    MOZ_RELEASE_ASSERT(IsMediaList(), "Wrong type!");
    return mValue.mMediaList.Value();
  }

  inline OwningNonNull<mozilla::dom::MediaList> const &
  GetAsMediaList() const
  {
    MOZ_RELEASE_ASSERT(IsMediaList(), "Wrong type!");
    return mValue.mMediaList.Value();
  }

  [[nodiscard]] bool&
  RawSetAsBoolean();

  [[nodiscard]] bool&
  SetAsBoolean();

  inline bool
  IsBoolean() const
  {
    return mType == eBoolean;
  }

  inline bool&
  GetAsBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool const &
  GetAsBoolean() const
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningMediaListOrBoolean&
  operator=(OwningMediaListOrBoolean&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningMediaListOrBoolean&
  operator=(const OwningMediaListOrBoolean& aOther);

private:
  bool
  TrySetToMediaList(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToMediaList(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyMediaList();

  bool
  TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyBoolean();
};


namespace CSSCustomMediaRule_Binding {

  typedef mozilla::dom::CSSCustomMediaRule NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::CSSCustomMediaRule* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::CSSCustomMediaRule,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace CSSCustomMediaRule_Binding



} // namespace mozilla::dom

#endif // DOM_CSSCUSTOMMEDIARULEBINDING_H_
