/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_net_idna_glue_h
#define mozilla_net_idna_glue_h

/* Generated with cbindgen:0.29.1 */

/* DO NOT MODIFY THIS MANUALLY! This file was generated using cbindgen. */

#include <cstdarg>
#include <cstdint>
#include <cstdlib>
#include <ostream>
#include <new>
#include "nsError.h"
#include "nsString.h"

extern "C" {

nsresult mozilla_net_domain_to_ascii_impl(const nsACString *src,
                                          bool allow_any_glyphful_ascii,
                                          nsACString *dst);

nsresult mozilla_net_domain_to_unicode_impl(const nsACString *src,
                                            bool allow_any_glyphful_ascii,
                                            nsACString *dst);

nsresult mozilla_net_domain_to_display_impl(const nsACString *src,
                                            bool allow_any_glyphful_ascii,
                                            nsACString *dst);

nsresult mozilla_net_domain_to_display_and_ascii_impl(const nsACString *src,
                                                      nsACString *dst,
                                                      nsACString *ascii_dst);

/// Not general-purpose! Only to be used from `nsDocShell::AttemptURIFixup`.
void mozilla_net_recover_keyword_from_punycode(const nsACString *src, nsACString *dst);

}  // extern "C"

#endif  // mozilla_net_idna_glue_h
