// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanBrowserExtensionsSearchDetectionMetrics_h
#define mozilla_GleanBrowserExtensionsSearchDetectionMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace addons_search_detection {
  /**
   * generated from addons.search_detection.etld_change_other
   */
  struct EtldChangeOtherExtra {
    mozilla::Maybe<nsCString> addonid;
    mozilla::Maybe<nsCString> addonversion;
    mozilla::Maybe<nsCString> from;
    mozilla::Maybe<nsCString> to;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonid) {
        extraKeys.AppendElement()->AssignASCII("addonId");
        extraValues.EmplaceBack(addonid.value());
      }
      if (addonversion) {
        extraKeys.AppendElement()->AssignASCII("addonVersion");
        extraValues.EmplaceBack(addonversion.value());
      }
      if (from) {
        extraKeys.AppendElement()->AssignASCII("from");
        extraValues.EmplaceBack(from.value());
      }
      if (to) {
        extraKeys.AppendElement()->AssignASCII("to");
        extraValues.EmplaceBack(to.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a request for a search query is redirected to another
   * domain via something other than the `webRequest` API.
   * This event was generated to correspond to the Legacy Telemetry event
   * addonsSearchDetection.etld_change#other.
   */
  constexpr impl::EventMetric<EtldChangeOtherExtra> etld_change_other(1032);

  /**
   * generated from addons.search_detection.etld_change_webrequest
   */
  struct EtldChangeWebrequestExtra {
    mozilla::Maybe<nsCString> addonid;
    mozilla::Maybe<nsCString> addonversion;
    mozilla::Maybe<nsCString> from;
    mozilla::Maybe<nsCString> to;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonid) {
        extraKeys.AppendElement()->AssignASCII("addonId");
        extraValues.EmplaceBack(addonid.value());
      }
      if (addonversion) {
        extraKeys.AppendElement()->AssignASCII("addonVersion");
        extraValues.EmplaceBack(addonversion.value());
      }
      if (from) {
        extraKeys.AppendElement()->AssignASCII("from");
        extraValues.EmplaceBack(from.value());
      }
      if (to) {
        extraKeys.AppendElement()->AssignASCII("to");
        extraValues.EmplaceBack(to.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a request for a search query is redirected to another
   * domain via the `webRequest` API.
   * This event was generated to correspond to the Legacy Telemetry event
   * addonsSearchDetection.etld_change#webrequest.
   */
  constexpr impl::EventMetric<EtldChangeWebrequestExtra> etld_change_webrequest(1033);

  /**
   * generated from addons.search_detection.same_site_redirect
   */
  struct SameSiteRedirectExtra {
    mozilla::Maybe<nsCString> addonid;
    mozilla::Maybe<nsCString> addonversion;
    mozilla::Maybe<nsCString> origin;
    mozilla::Maybe<nsCString> paramchanged;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonid) {
        extraKeys.AppendElement()->AssignASCII("addonId");
        extraValues.EmplaceBack(addonid.value());
      }
      if (addonversion) {
        extraKeys.AppendElement()->AssignASCII("addonVersion");
        extraValues.EmplaceBack(addonversion.value());
      }
      if (origin) {
        extraKeys.AppendElement()->AssignASCII("origin");
        extraValues.EmplaceBack(origin.value());
      }
      if (paramchanged) {
        extraKeys.AppendElement()->AssignASCII("paramChanged");
        extraValues.EmplaceBack(paramchanged.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a request for a search query is redirected
   * within the same eTLD site via the `webRequest` API.
   */
  constexpr impl::EventMetric<SameSiteRedirectExtra> same_site_redirect(1034);
}

} // namespace mozilla::glean

#endif // mozilla_GleanBrowserExtensionsSearchDetectionMetrics_h
