// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanReaderMetrics_h
#define mozilla_GleanReaderMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace readermode {
  /**
   * generated from readermode.button_click
   */
  struct ButtonClickExtra {
    mozilla::Maybe<nsCString> label;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (label) {
        extraKeys.AppendElement()->AssignASCII("label");
        extraValues.EmplaceBack(label.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded any time a Reader Mode button is clicked. This event was generated to correspond to the Legacy Telemetry event readermode.button#click.
   */
  constexpr impl::EventMetric<ButtonClickExtra> button_click(5345);

  /**
   * generated from readermode.download_result
   * The result of trying to download a document to show in reader view (0=Success, 1=Error XHR, 2=Error no document)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram READER_MODE_DOWNLOAD_RESULT.
   */
  constexpr impl::CustomDistributionMetric download_result(5346);

  /**
   * generated from readermode.parse_result
   * The result of trying to parse a document to show in reader view (0=Success, 1=Error too many elements, 2=Error in worker, 3=Error no article)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram READER_MODE_PARSE_RESULT.
   */
  constexpr impl::CustomDistributionMetric parse_result(5347);

  /**
   * generated from readermode.view_off
   */
  struct ViewOffExtra {
    mozilla::Maybe<nsCString> readerTime;
    mozilla::Maybe<nsCString> scrollPosition;
    mozilla::Maybe<nsCString> subcategory;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (readerTime) {
        extraKeys.AppendElement()->AssignASCII("reader_time");
        extraValues.EmplaceBack(readerTime.value());
      }
      if (scrollPosition) {
        extraKeys.AppendElement()->AssignASCII("scroll_position");
        extraValues.EmplaceBack(scrollPosition.value());
      }
      if (subcategory) {
        extraKeys.AppendElement()->AssignASCII("subcategory");
        extraValues.EmplaceBack(subcategory.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded any time Reader Mode is turned on or off. This event was generated to correspond to the Legacy Telemetry event readermode.view#off.
   */
  constexpr impl::EventMetric<ViewOffExtra> view_off(5348);

  /**
   * generated from readermode.view_on
   */
  struct ViewOnExtra {
    mozilla::Maybe<nsCString> readerTime;
    mozilla::Maybe<nsCString> scrollPosition;
    mozilla::Maybe<nsCString> subcategory;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (readerTime) {
        extraKeys.AppendElement()->AssignASCII("reader_time");
        extraValues.EmplaceBack(readerTime.value());
      }
      if (scrollPosition) {
        extraKeys.AppendElement()->AssignASCII("scroll_position");
        extraValues.EmplaceBack(scrollPosition.value());
      }
      if (subcategory) {
        extraKeys.AppendElement()->AssignASCII("subcategory");
        extraValues.EmplaceBack(subcategory.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded any time Reader Mode is turned on or off. This event was generated to correspond to the Legacy Telemetry event readermode.view#on.
   */
  constexpr impl::EventMetric<ViewOnExtra> view_on(5349);
}

} // namespace mozilla::glean

#endif // mozilla_GleanReaderMetrics_h
